/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.BasePartition;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class HashPartition
extends BasePartition {
    private PartitionOptions partitionOptions;

    public HashPartition(@NonNull ParserRuleContext context, @NonNull List<Expression> targets, List<HashPartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum) {
        super(context, targets, partitionElements, subPartitionOption, partitionsNum);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (targets == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
    }

    public HashPartition(@NonNull List<Expression> targets, List<HashPartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum) {
        super(targets, partitionElements, subPartitionOption, partitionsNum);
        if (targets == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PARTITION BY HASH");
        builder.append("(").append(this.getPartitionTargets().stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        if (this.getSubPartitionOption() != null) {
            builder.append(" ").append(this.getSubPartitionOption());
        }
        if (this.getPartitionsNum() != null) {
            builder.append(" PARTITIONS ").append(this.getPartitionsNum());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getPartitionElements())) {
            builder.append(" (\n\t").append(this.getPartitionElements().stream().map(Object::toString).collect(Collectors.joining(",\n\t"))).append("\n)");
        }
        if (this.partitionOptions != null) {
            builder.append(" ").append(this.partitionOptions);
        }
        return builder.toString();
    }

    public PartitionOptions getPartitionOptions() {
        return this.partitionOptions;
    }

    public void setPartitionOptions(PartitionOptions partitionOptions) {
        this.partitionOptions = partitionOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashPartition)) {
            return false;
        }
        HashPartition other = (HashPartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PartitionOptions this$partitionOptions = this.getPartitionOptions();
        PartitionOptions other$partitionOptions = other.getPartitionOptions();
        return !(this$partitionOptions == null ? other$partitionOptions != null : !((Object)this$partitionOptions).equals(other$partitionOptions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HashPartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PartitionOptions $partitionOptions = this.getPartitionOptions();
        result = result * 59 + ($partitionOptions == null ? 43 : ((Object)$partitionOptions).hashCode());
        return result;
    }
}

