/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class SetComment
extends BaseStatement {
    private final RelationFactor table;
    private final ColumnReference column;
    private final String comment;

    public SetComment(@NonNull ParserRuleContext context, @NonNull RelationFactor table, @NonNull String comment) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        this.comment = comment;
        this.table = table;
        this.column = null;
    }

    public SetComment(@NonNull ParserRuleContext context, @NonNull ColumnReference column, @NonNull String comment) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        this.comment = comment;
        this.table = null;
        this.column = column;
    }

    public SetComment(@NonNull RelationFactor table, @NonNull String comment) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        this.comment = comment;
        this.table = table;
        this.column = null;
    }

    public SetComment(@NonNull ColumnReference column, @NonNull String comment) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        this.comment = comment;
        this.table = null;
        this.column = column;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("COMMENT ON");
        if (this.table != null) {
            builder.append(" TABLE ").append(this.table);
        } else if (this.column != null) {
            builder.append(" COLUMN ").append(this.column);
        }
        return builder.append(" IS ").append(this.comment).toString();
    }

    public RelationFactor getTable() {
        return this.table;
    }

    public ColumnReference getColumn() {
        return this.column;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetComment)) {
            return false;
        }
        SetComment other = (SetComment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationFactor this$table = this.getTable();
        RelationFactor other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        ColumnReference this$column = this.getColumn();
        ColumnReference other$column = other.getColumn();
        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetComment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationFactor $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        ColumnReference $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }
}

