/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnGroupElementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLPartitionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableElementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableOptionsFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createtable.CreateTable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLCreateTableFactory
extends OBParserBaseVisitor<CreateTable>
implements StatementFactory<CreateTable> {
    private final ParserRuleContext parserRuleContext;

    public MySQLCreateTableFactory(@NonNull OBParser.Create_table_stmtContext createTableStmtContext) {
        if (createTableStmtContext == null) {
            throw new NullPointerException("createTableStmtContext is marked non-null but is null");
        }
        this.parserRuleContext = createTableStmtContext;
    }

    public MySQLCreateTableFactory(@NonNull OBParser.Create_table_like_stmtContext createTableLikeStmtContext) {
        if (createTableLikeStmtContext == null) {
            throw new NullPointerException("createTableLikeStmtContext is marked non-null but is null");
        }
        this.parserRuleContext = createTableLikeStmtContext;
    }

    @Override
    public CreateTable generate() {
        return (CreateTable)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public CreateTable visitCreate_table_like_stmt(OBParser.Create_table_like_stmtContext ctx) {
        RelationFactor factor = MySQLFromReferenceFactory.getRelationFactor(ctx.relation_factor(0));
        CreateTable createTable = new CreateTable((ParserRuleContext)ctx, factor);
        if (ctx.special_table_type().TEMPORARY() != null) {
            createTable.setTemporary(true);
        } else if (ctx.special_table_type().EXTERNAL() != null) {
            createTable.setExternal(true);
        }
        if (ctx.IF() != null && ctx.not() != null && ctx.EXISTS() != null) {
            createTable.setIfNotExists(true);
        }
        createTable.setUserVariable(factor.getUserVariable());
        RelationFactor likeFactor = MySQLFromReferenceFactory.getRelationFactor(ctx.relation_factor(1));
        createTable.setLikeTable(likeFactor);
        return createTable;
    }

    @Override
    public CreateTable visitCreate_table_stmt(OBParser.Create_table_stmtContext ctx) {
        RelationFactor factor = MySQLFromReferenceFactory.getRelationFactor(ctx.relation_factor());
        CreateTable createTable = new CreateTable((ParserRuleContext)ctx, factor);
        if (ctx.special_table_type() != null) {
            OBParser.Special_table_typeContext specialTableTypeContext = ctx.special_table_type();
            if (specialTableTypeContext.EXTERNAL() != null) {
                createTable.setExternal(true);
            } else if (specialTableTypeContext.TEMPORARY() != null) {
                createTable.setTemporary(true);
            }
        }
        if (ctx.IF() != null && ctx.not() != null && ctx.EXISTS() != null) {
            createTable.setIfNotExists(true);
        }
        createTable.setUserVariable(factor.getUserVariable());
        if (ctx.table_element_list() != null) {
            createTable.setTableElements(ctx.table_element_list().table_element().stream().map(c -> new MySQLTableElementFactory((OBParser.Table_elementContext)((Object)c)).generate()).collect(Collectors.toList()));
        } else {
            createTable.setAs(new MySQLSelectFactory(ctx.select_stmt()).generate());
        }
        if (ctx.table_option_list() != null) {
            createTable.setTableOptions(new MySQLTableOptionsFactory(ctx.table_option_list()).generate());
        }
        if (ctx.partition_option() != null) {
            createTable.setPartition(new MySQLPartitionFactory(ctx.partition_option()).generate());
        }
        if (ctx.auto_partition_option() != null) {
            createTable.setPartition(new MySQLPartitionFactory(ctx.auto_partition_option()).generate());
        }
        if (ctx.with_column_group() != null) {
            List<ColumnGroupElement> columnGroupElements = ctx.with_column_group().column_group_list().column_group_element().stream().map(c -> new MySQLColumnGroupElementFactory((OBParser.Column_group_elementContext)((Object)c)).generate()).collect(Collectors.toList());
            createTable.setColumnGroupElements(columnGroupElements);
        }
        return createTable;
    }
}

