/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.SortDirection;
import com.oceanbase.tools.sqlparser.statement.select.SortKey;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLSortKeyFactory
extends OBParserBaseVisitor<SortKey>
implements StatementFactory<SortKey> {
    private final OBParser.Sort_keyContext sortKeyContext;
    private final OBParser.Sort_key_for_group_byContext sortKeyForGroupByContext;

    public MySQLSortKeyFactory(@NonNull OBParser.Sort_keyContext sortKeyContext) {
        if (sortKeyContext == null) {
            throw new NullPointerException("sortKeyContext is marked non-null but is null");
        }
        this.sortKeyForGroupByContext = null;
        this.sortKeyContext = sortKeyContext;
    }

    public MySQLSortKeyFactory(@NonNull OBParser.Sort_key_for_group_byContext sortKeyForGroupByContext) {
        if (sortKeyForGroupByContext == null) {
            throw new NullPointerException("sortKeyForGroupByContext is marked non-null but is null");
        }
        this.sortKeyContext = null;
        this.sortKeyForGroupByContext = sortKeyForGroupByContext;
    }

    @Override
    public SortKey generate() {
        if (this.sortKeyContext != null) {
            return (SortKey)this.visit((ParseTree)this.sortKeyContext);
        }
        return (SortKey)this.visit((ParseTree)this.sortKeyForGroupByContext);
    }

    @Override
    public SortKey visitSort_key(OBParser.Sort_keyContext ctx) {
        MySQLExpressionFactory factory = new MySQLExpressionFactory(ctx.expr());
        SortDirection direction = null;
        if (ctx.ASC() != null) {
            direction = SortDirection.ASC;
        } else if (ctx.DESC() != null) {
            direction = SortDirection.DESC;
        }
        return new SortKey(ctx, (Expression)factory.generate(), direction);
    }

    @Override
    public SortKey visitSort_key_for_group_by(OBParser.Sort_key_for_group_byContext ctx) {
        MySQLExpressionFactory factory = new MySQLExpressionFactory(ctx.expr());
        SortDirection direction = null;
        if (ctx.ASC() != null) {
            direction = SortDirection.ASC;
        } else if (ctx.DESC() != null) {
            direction = SortDirection.DESC;
        }
        return new SortKey(ctx, (Expression)factory.generate(), direction);
    }
}

