/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.select.SortDirection;
import com.oceanbase.tools.sqlparser.statement.select.SortKey;
import com.oceanbase.tools.sqlparser.statement.select.oracle.SortNullPosition;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleSortKeyFactory
extends OBParserBaseVisitor<SortKey>
implements StatementFactory<SortKey> {
    private final OBParser.Sort_keyContext sortKeyContext;

    public OracleSortKeyFactory(@NonNull OBParser.Sort_keyContext sortKeyContext) {
        if (sortKeyContext == null) {
            throw new NullPointerException("sortKeyContext is marked non-null but is null");
        }
        this.sortKeyContext = sortKeyContext;
    }

    @Override
    public SortKey generate() {
        return (SortKey)this.visit((ParseTree)this.sortKeyContext);
    }

    @Override
    public SortKey visitSort_key(OBParser.Sort_keyContext ctx) {
        OracleExpressionFactory factory = new OracleExpressionFactory(ctx.bit_expr());
        OBParser.Opt_asc_descContext optAscDesc = ctx.opt_asc_desc();
        return new SortKey(ctx, factory.generate(), OracleSortKeyFactory.getSortDirection(optAscDesc), OracleSortKeyFactory.getSortNullPosition(optAscDesc));
    }

    public static SortDirection getSortDirection(OBParser.Opt_asc_descContext optAscDesc) {
        SortDirection direction = null;
        OBParser.Opt_ascending_typeContext optAscendingType = optAscDesc.opt_ascending_type();
        if (optAscendingType != null && (optAscendingType.ASC() != null || optAscendingType.DESC() != null)) {
            direction = optAscendingType.ASC() == null ? SortDirection.DESC : SortDirection.ASC;
        }
        return direction;
    }

    public static SortNullPosition getSortNullPosition(OBParser.Opt_asc_descContext optAscDesc) {
        OBParser.Opt_null_posContext optNullPos = optAscDesc.opt_null_pos();
        SortNullPosition nullPosition = null;
        if (optNullPos != null && (optNullPos.LAST() != null || optNullPos.FIRST() != null)) {
            nullPosition = optNullPos.LAST() == null ? SortNullPosition.FIRST : SortNullPosition.LAST;
        }
        return nullPosition;
    }
}

