/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.alter.table;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.alter.table.PartitionSplitActions;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnDefinition;
import com.oceanbase.tools.sqlparser.statement.createtable.ConstraintState;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineIndex;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.TableOptions;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class AlterTableAction
extends BaseStatement {
    private TableOptions tableOptions;
    private Boolean moveNoCompress;
    private Boolean removePartitioning;
    private String moveCompress;
    private List<ColumnDefinition> addColumns;
    private List<ColumnReference> dropColumns;
    private String dropSingleColumnOption;
    private List<ColumnDefinition> modifyColumns;
    private ColumnReference renameFromColumn;
    private String renameToColumnName;
    private Boolean dropTableGroup;
    private RelationFactor renameToTable;
    private OutOfLineConstraint addConstraint;
    private String alterIndexName;
    private Boolean alterIndexVisible;
    private Integer alterIndexParallel;
    private Boolean alterIndexNoParallel;
    private List<String> dropConstraintNames;
    private String modifyConstraintName;
    private ConstraintState modifyConstraintState;
    private Boolean updateGlobalIndexes;
    private List<String> truncatePartitionNames;
    private List<String> truncateSubPartitionNames;
    private List<String> dropPartitionNames;
    private List<String> dropSubPartitionNames;
    private List<PartitionElement> addPartitionElements;
    private RelationFactor addSubPartitionElementTo;
    private List<SubPartitionElement> addSubPartitionElements;
    private Partition modifyPartition;
    private RelationFactor splitPartition;
    private PartitionSplitActions splitActions;
    private Expression interval;
    private Boolean enableAllTriggers;
    private ColumnReference alterColumn;
    private AlterColumnBehavior alterColumnBehavior;
    private ColumnReference changeColumn;
    private ColumnDefinition changeColumnDefinition;
    private OutOfLineIndex addIndex;
    private String dropIndexName;
    private String dropForeignKeyName;
    private String renameFromIndexName;
    private String renameToIndexName;
    private List<String> reorganizePartitionNames;
    private List<PartitionElement> reorganizePartitionIntos;
    private String charset;
    private String collation;
    private Boolean dropPrimaryKey;
    private OutOfLineConstraint modifyPrimaryKey;
    private boolean refresh;
    private String renameFromPartitionName;
    private String renameToPartitionName;
    private String renameFromSubPartitionName;
    private String renameToSubPartitionName;
    private List<ColumnGroupElement> addColumnGroupElements;
    private List<ColumnGroupElement> dropColumnGroupElements;

    public AlterTableAction(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public void setDropColumn(@NonNull ColumnReference dropColumn, String dropColumnOption) {
        if (dropColumn == null) {
            throw new NullPointerException("dropColumn is marked non-null but is null");
        }
        this.dropColumns = Collections.singletonList(dropColumn);
        this.dropSingleColumnOption = dropColumnOption;
    }

    public void renameColumn(@NonNull ColumnReference from, @NonNull String to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.renameFromColumn = from;
        this.renameToColumnName = to;
    }

    public void renamePartition(@NonNull String from, @NonNull String to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.renameFromPartitionName = from;
        this.renameToPartitionName = to;
    }

    public void renameSubPartition(@NonNull String from, @NonNull String to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.renameFromSubPartitionName = from;
        this.renameToSubPartitionName = to;
    }

    public void renameIndex(@NonNull String from, @NonNull String to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.renameFromIndexName = from;
        this.renameToIndexName = to;
    }

    public void alterIndexVisibility(@NonNull String indexName, boolean visibility) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        this.alterIndexName = indexName;
        this.alterIndexVisible = visibility;
    }

    public void alterIndexNoParallel(@NonNull String indexName) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        this.alterIndexName = indexName;
        this.alterIndexNoParallel = true;
    }

    public void alterIndexParallel(@NonNull String indexName, int parallel) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        this.alterIndexName = indexName;
        this.alterIndexParallel = parallel;
    }

    public void modifyConstraint(@NonNull String constraintName, @NonNull ConstraintState state) {
        if (constraintName == null) {
            throw new NullPointerException("constraintName is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.modifyConstraintName = constraintName;
        this.modifyConstraintState = state;
    }

    public void addSubpartitionElements(@NonNull RelationFactor target, @NonNull List<SubPartitionElement> subPartitionElements) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (subPartitionElements == null) {
            throw new NullPointerException("subPartitionElements is marked non-null but is null");
        }
        this.addSubPartitionElementTo = target;
        this.addSubPartitionElements = subPartitionElements;
    }

    public void splitPartition(@NonNull RelationFactor target, @NonNull PartitionSplitActions splitActions) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (splitActions == null) {
            throw new NullPointerException("splitActions is marked non-null but is null");
        }
        this.splitPartition = target;
        this.splitActions = splitActions;
    }

    public void alterColumnBehavior(@NonNull ColumnReference column, @NonNull AlterColumnBehavior behavior) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (behavior == null) {
            throw new NullPointerException("behavior is marked non-null but is null");
        }
        this.alterColumn = column;
        this.alterColumnBehavior = behavior;
    }

    public void changeColumn(@NonNull ColumnReference column, @NonNull ColumnDefinition definition) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (definition == null) {
            throw new NullPointerException("definition is marked non-null but is null");
        }
        this.changeColumn = column;
        this.changeColumnDefinition = definition;
    }

    public void reorganizePartition(@NonNull List<String> names, @NonNull List<PartitionElement> partitionElements) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        if (partitionElements == null) {
            throw new NullPointerException("partitionElements is marked non-null but is null");
        }
        this.reorganizePartitionNames = names;
        this.reorganizePartitionIntos = partitionElements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.tableOptions != null) {
            builder.append(" SET ").append(this.tableOptions);
        }
        if (Boolean.TRUE.equals(this.moveNoCompress)) {
            builder.append(" MOVE NOCOMPRESS");
        }
        if (this.moveCompress != null) {
            builder.append(" MOVE COMPRESS ").append(this.moveCompress);
        }
        if (CollectionUtils.isNotEmpty(this.addColumns)) {
            if (this.addColumns.size() == 1) {
                builder.append(" ADD ").append(this.addColumns.get(0));
            } else {
                builder.append(" ADD(").append(this.addColumns.stream().map(ColumnDefinition::toString).collect(Collectors.joining(","))).append(")");
            }
        }
        if (CollectionUtils.isNotEmpty(this.dropColumns)) {
            if (this.dropColumns.size() == 1) {
                builder.append(" DROP COLUMN ").append(this.dropColumns.get(0));
                if (this.dropSingleColumnOption != null) {
                    builder.append(" ").append(this.dropSingleColumnOption);
                }
            } else {
                builder.append(" DROP(").append(this.dropColumns.stream().map(BaseExpression::toString).collect(Collectors.joining(","))).append(")");
            }
        }
        if (this.renameFromColumn != null && this.renameToColumnName != null) {
            builder.append(" RENAME COLUMN ").append(this.renameFromColumn).append(" TO ").append(this.renameToColumnName);
        }
        if (CollectionUtils.isNotEmpty(this.modifyColumns)) {
            if (this.modifyColumns.size() == 1) {
                builder.append(" MODIFY ").append(this.modifyColumns.get(0));
            } else {
                builder.append(" MODIFY(").append(this.modifyColumns.stream().map(ColumnDefinition::toString).collect(Collectors.joining(","))).append(")");
            }
        }
        if (Boolean.TRUE.equals(this.dropTableGroup)) {
            builder.append(" DROP TABLEGROUP");
        }
        if (this.renameToTable != null) {
            builder.append(" RENAME TO ").append(this.renameToTable);
        }
        if (this.addConstraint != null) {
            builder.append(" ADD ").append(this.addConstraint);
        }
        if (this.alterIndexName != null && this.alterIndexVisible != null) {
            builder.append(" ALTER INDEX ").append(this.alterIndexName).append(" ").append(this.alterIndexVisible != false ? "VISIBLE" : "INVISIBLE");
        }
        if (this.alterIndexName != null && Boolean.TRUE.equals(this.alterIndexNoParallel)) {
            builder.append(" ALTER INDEX ").append(this.alterIndexName).append(" NOPARALLEL");
        }
        if (this.alterIndexName != null && this.alterIndexParallel != null) {
            builder.append(" ALTER INDEX ").append(this.alterIndexName).append(" PARALLEL=").append(this.alterIndexParallel);
        }
        if (this.modifyConstraintName != null && this.modifyConstraintState != null) {
            builder.append(" MODIFY CONSTRAINT ").append(this.modifyConstraintName).append(" ").append(this.modifyConstraintState);
        }
        if (CollectionUtils.isNotEmpty(this.dropPartitionNames)) {
            builder.append(" DROP PARTITION ").append(String.join((CharSequence)",", this.dropPartitionNames));
            this.appendUpdateGlobalIndexes(builder);
        }
        if (CollectionUtils.isNotEmpty(this.dropSubPartitionNames)) {
            builder.append(" DROP SUBPARTITION ").append(String.join((CharSequence)",", this.dropSubPartitionNames));
            this.appendUpdateGlobalIndexes(builder);
        }
        if (CollectionUtils.isNotEmpty(this.truncatePartitionNames)) {
            builder.append(" TRUNCATE PARTITION ").append(String.join((CharSequence)",", this.truncatePartitionNames));
            this.appendUpdateGlobalIndexes(builder);
        }
        if (CollectionUtils.isNotEmpty(this.truncateSubPartitionNames)) {
            builder.append(" TRUNCATE SUBPARTITION ").append(String.join((CharSequence)",", this.truncateSubPartitionNames));
            this.appendUpdateGlobalIndexes(builder);
        }
        if (CollectionUtils.isNotEmpty(this.addPartitionElements)) {
            builder.append(" ADD ").append(this.addPartitionElements.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (this.addSubPartitionElementTo != null && CollectionUtils.isNotEmpty(this.addSubPartitionElements)) {
            builder.append(" MODIFY PARTITION ").append(this.addSubPartitionElementTo).append(" ADD ").append(this.addSubPartitionElements.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (this.splitActions != null && this.splitPartition != null) {
            builder.append(" SPLIT PARTITION ").append(this.splitPartition).append(" ").append(this.splitActions);
        }
        if (this.modifyPartition != null) {
            builder.append(" MODIFY ").append(this.modifyPartition);
        }
        if (CollectionUtils.isNotEmpty(this.dropConstraintNames)) {
            if (this.dropConstraintNames.size() == 1) {
                builder.append(" DROP CONSTRAINT ").append(this.dropConstraintNames.get(0));
            } else {
                builder.append(" DROP CONSTRAINT(").append(String.join((CharSequence)",", this.dropConstraintNames)).append(")");
            }
        }
        if (this.renameFromPartitionName != null && this.renameToPartitionName != null) {
            builder.append(" RENAME PARTITION ").append(this.renameFromPartitionName).append(" TO ").append(this.renameToPartitionName);
        }
        if (this.renameFromSubPartitionName != null && this.renameToSubPartitionName != null) {
            builder.append(" RENAME SUBPARTITION ").append(this.renameFromSubPartitionName).append(" TO ").append(this.renameToSubPartitionName);
        }
        if (this.alterColumn != null && this.alterColumnBehavior != null) {
            builder.append(" ALTER ").append(this.alterColumn).append(" ").append(this.alterColumnBehavior);
        }
        if (this.changeColumnDefinition != null && this.changeColumn != null) {
            builder.append(" CHANGE ").append(this.changeColumn).append(" ").append(this.changeColumnDefinition);
        }
        if (this.addIndex != null) {
            builder.append(" ADD ").append(this.addIndex);
        }
        if (this.dropIndexName != null) {
            builder.append(" DROP INDEX ").append(this.dropIndexName);
        }
        if (this.renameFromIndexName != null && this.renameToIndexName != null) {
            builder.append(" RENAME INDEX ").append(this.renameFromIndexName).append(" TO ").append(this.renameToIndexName);
        }
        if (this.reorganizePartitionIntos != null && this.reorganizePartitionNames != null) {
            builder.append(" REORGANIZE PARTITION ").append(String.join((CharSequence)",", this.reorganizePartitionNames)).append(" INTO (").append(this.reorganizePartitionIntos.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.dropForeignKeyName != null) {
            builder.append(" DROP FOREIGN KEY ").append(this.dropForeignKeyName);
        }
        if (this.charset != null || this.collation != null) {
            builder.append(" CONVERT TO CHARACTER SET");
            if (this.charset != null) {
                builder.append(" ").append(this.charset);
            }
            if (this.collation != null) {
                builder.append(" COLLATE ").append(this.collation);
            }
        }
        if (this.interval != null) {
            builder.append(" SET INTERVAL(").append(this.interval).append(")");
        }
        if (this.enableAllTriggers != null) {
            builder.append(" ").append(this.enableAllTriggers != false ? "ENABLE" : "DISABLE").append(" ALL TRIGGERS");
        }
        if (Boolean.TRUE.equals(this.dropPrimaryKey)) {
            builder.append(" DROP PRIMARY KEY");
        }
        if (this.modifyPrimaryKey != null) {
            builder.append(" MODIFY ").append(this.modifyPrimaryKey);
        }
        if (this.refresh) {
            builder.append(" REFRESH");
        }
        if (Boolean.TRUE.equals(this.removePartitioning)) {
            builder.append(" REMOVE PARTITIONING");
        }
        if (this.addColumnGroupElements != null) {
            builder.append(" ADD COLUMN GROUP(").append(this.addColumnGroupElements.stream().map(ColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.dropColumnGroupElements != null) {
            builder.append(" DROP COLUMN GROUP(").append(this.dropColumnGroupElements.stream().map(ColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    private void appendUpdateGlobalIndexes(StringBuilder builder) {
        if (Boolean.TRUE.equals(this.updateGlobalIndexes)) {
            builder.append(" UPDATE GLOBAL INDEXES");
        }
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public Boolean getMoveNoCompress() {
        return this.moveNoCompress;
    }

    public Boolean getRemovePartitioning() {
        return this.removePartitioning;
    }

    public String getMoveCompress() {
        return this.moveCompress;
    }

    public List<ColumnDefinition> getAddColumns() {
        return this.addColumns;
    }

    public List<ColumnReference> getDropColumns() {
        return this.dropColumns;
    }

    public String getDropSingleColumnOption() {
        return this.dropSingleColumnOption;
    }

    public List<ColumnDefinition> getModifyColumns() {
        return this.modifyColumns;
    }

    public ColumnReference getRenameFromColumn() {
        return this.renameFromColumn;
    }

    public String getRenameToColumnName() {
        return this.renameToColumnName;
    }

    public Boolean getDropTableGroup() {
        return this.dropTableGroup;
    }

    public RelationFactor getRenameToTable() {
        return this.renameToTable;
    }

    public OutOfLineConstraint getAddConstraint() {
        return this.addConstraint;
    }

    public String getAlterIndexName() {
        return this.alterIndexName;
    }

    public Boolean getAlterIndexVisible() {
        return this.alterIndexVisible;
    }

    public Integer getAlterIndexParallel() {
        return this.alterIndexParallel;
    }

    public Boolean getAlterIndexNoParallel() {
        return this.alterIndexNoParallel;
    }

    public List<String> getDropConstraintNames() {
        return this.dropConstraintNames;
    }

    public String getModifyConstraintName() {
        return this.modifyConstraintName;
    }

    public ConstraintState getModifyConstraintState() {
        return this.modifyConstraintState;
    }

    public Boolean getUpdateGlobalIndexes() {
        return this.updateGlobalIndexes;
    }

    public List<String> getTruncatePartitionNames() {
        return this.truncatePartitionNames;
    }

    public List<String> getTruncateSubPartitionNames() {
        return this.truncateSubPartitionNames;
    }

    public List<String> getDropPartitionNames() {
        return this.dropPartitionNames;
    }

    public List<String> getDropSubPartitionNames() {
        return this.dropSubPartitionNames;
    }

    public List<PartitionElement> getAddPartitionElements() {
        return this.addPartitionElements;
    }

    public RelationFactor getAddSubPartitionElementTo() {
        return this.addSubPartitionElementTo;
    }

    public List<SubPartitionElement> getAddSubPartitionElements() {
        return this.addSubPartitionElements;
    }

    public Partition getModifyPartition() {
        return this.modifyPartition;
    }

    public RelationFactor getSplitPartition() {
        return this.splitPartition;
    }

    public PartitionSplitActions getSplitActions() {
        return this.splitActions;
    }

    public Expression getInterval() {
        return this.interval;
    }

    public Boolean getEnableAllTriggers() {
        return this.enableAllTriggers;
    }

    public ColumnReference getAlterColumn() {
        return this.alterColumn;
    }

    public AlterColumnBehavior getAlterColumnBehavior() {
        return this.alterColumnBehavior;
    }

    public ColumnReference getChangeColumn() {
        return this.changeColumn;
    }

    public ColumnDefinition getChangeColumnDefinition() {
        return this.changeColumnDefinition;
    }

    public OutOfLineIndex getAddIndex() {
        return this.addIndex;
    }

    public String getDropIndexName() {
        return this.dropIndexName;
    }

    public String getDropForeignKeyName() {
        return this.dropForeignKeyName;
    }

    public String getRenameFromIndexName() {
        return this.renameFromIndexName;
    }

    public String getRenameToIndexName() {
        return this.renameToIndexName;
    }

    public List<String> getReorganizePartitionNames() {
        return this.reorganizePartitionNames;
    }

    public List<PartitionElement> getReorganizePartitionIntos() {
        return this.reorganizePartitionIntos;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollation() {
        return this.collation;
    }

    public Boolean getDropPrimaryKey() {
        return this.dropPrimaryKey;
    }

    public OutOfLineConstraint getModifyPrimaryKey() {
        return this.modifyPrimaryKey;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public String getRenameFromPartitionName() {
        return this.renameFromPartitionName;
    }

    public String getRenameToPartitionName() {
        return this.renameToPartitionName;
    }

    public String getRenameFromSubPartitionName() {
        return this.renameFromSubPartitionName;
    }

    public String getRenameToSubPartitionName() {
        return this.renameToSubPartitionName;
    }

    public List<ColumnGroupElement> getAddColumnGroupElements() {
        return this.addColumnGroupElements;
    }

    public List<ColumnGroupElement> getDropColumnGroupElements() {
        return this.dropColumnGroupElements;
    }

    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    public void setMoveNoCompress(Boolean moveNoCompress) {
        this.moveNoCompress = moveNoCompress;
    }

    public void setRemovePartitioning(Boolean removePartitioning) {
        this.removePartitioning = removePartitioning;
    }

    public void setMoveCompress(String moveCompress) {
        this.moveCompress = moveCompress;
    }

    public void setAddColumns(List<ColumnDefinition> addColumns) {
        this.addColumns = addColumns;
    }

    public void setDropColumns(List<ColumnReference> dropColumns) {
        this.dropColumns = dropColumns;
    }

    public void setModifyColumns(List<ColumnDefinition> modifyColumns) {
        this.modifyColumns = modifyColumns;
    }

    public void setDropTableGroup(Boolean dropTableGroup) {
        this.dropTableGroup = dropTableGroup;
    }

    public void setRenameToTable(RelationFactor renameToTable) {
        this.renameToTable = renameToTable;
    }

    public void setAddConstraint(OutOfLineConstraint addConstraint) {
        this.addConstraint = addConstraint;
    }

    public void setDropConstraintNames(List<String> dropConstraintNames) {
        this.dropConstraintNames = dropConstraintNames;
    }

    public void setUpdateGlobalIndexes(Boolean updateGlobalIndexes) {
        this.updateGlobalIndexes = updateGlobalIndexes;
    }

    public void setTruncatePartitionNames(List<String> truncatePartitionNames) {
        this.truncatePartitionNames = truncatePartitionNames;
    }

    public void setTruncateSubPartitionNames(List<String> truncateSubPartitionNames) {
        this.truncateSubPartitionNames = truncateSubPartitionNames;
    }

    public void setDropPartitionNames(List<String> dropPartitionNames) {
        this.dropPartitionNames = dropPartitionNames;
    }

    public void setDropSubPartitionNames(List<String> dropSubPartitionNames) {
        this.dropSubPartitionNames = dropSubPartitionNames;
    }

    public void setAddPartitionElements(List<PartitionElement> addPartitionElements) {
        this.addPartitionElements = addPartitionElements;
    }

    public void setModifyPartition(Partition modifyPartition) {
        this.modifyPartition = modifyPartition;
    }

    public void setInterval(Expression interval) {
        this.interval = interval;
    }

    public void setEnableAllTriggers(Boolean enableAllTriggers) {
        this.enableAllTriggers = enableAllTriggers;
    }

    public void setAddIndex(OutOfLineIndex addIndex) {
        this.addIndex = addIndex;
    }

    public void setDropIndexName(String dropIndexName) {
        this.dropIndexName = dropIndexName;
    }

    public void setDropForeignKeyName(String dropForeignKeyName) {
        this.dropForeignKeyName = dropForeignKeyName;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public void setDropPrimaryKey(Boolean dropPrimaryKey) {
        this.dropPrimaryKey = dropPrimaryKey;
    }

    public void setModifyPrimaryKey(OutOfLineConstraint modifyPrimaryKey) {
        this.modifyPrimaryKey = modifyPrimaryKey;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setAddColumnGroupElements(List<ColumnGroupElement> addColumnGroupElements) {
        this.addColumnGroupElements = addColumnGroupElements;
    }

    public void setDropColumnGroupElements(List<ColumnGroupElement> dropColumnGroupElements) {
        this.dropColumnGroupElements = dropColumnGroupElements;
    }

    public AlterTableAction() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlterTableAction)) {
            return false;
        }
        AlterTableAction other = (AlterTableAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableOptions this$tableOptions = this.getTableOptions();
        TableOptions other$tableOptions = other.getTableOptions();
        if (this$tableOptions == null ? other$tableOptions != null : !((Object)this$tableOptions).equals(other$tableOptions)) {
            return false;
        }
        Boolean this$moveNoCompress = this.getMoveNoCompress();
        Boolean other$moveNoCompress = other.getMoveNoCompress();
        if (this$moveNoCompress == null ? other$moveNoCompress != null : !((Object)this$moveNoCompress).equals(other$moveNoCompress)) {
            return false;
        }
        Boolean this$removePartitioning = this.getRemovePartitioning();
        Boolean other$removePartitioning = other.getRemovePartitioning();
        if (this$removePartitioning == null ? other$removePartitioning != null : !((Object)this$removePartitioning).equals(other$removePartitioning)) {
            return false;
        }
        String this$moveCompress = this.getMoveCompress();
        String other$moveCompress = other.getMoveCompress();
        if (this$moveCompress == null ? other$moveCompress != null : !this$moveCompress.equals(other$moveCompress)) {
            return false;
        }
        List<ColumnDefinition> this$addColumns = this.getAddColumns();
        List<ColumnDefinition> other$addColumns = other.getAddColumns();
        if (this$addColumns == null ? other$addColumns != null : !((Object)this$addColumns).equals(other$addColumns)) {
            return false;
        }
        List<ColumnReference> this$dropColumns = this.getDropColumns();
        List<ColumnReference> other$dropColumns = other.getDropColumns();
        if (this$dropColumns == null ? other$dropColumns != null : !((Object)this$dropColumns).equals(other$dropColumns)) {
            return false;
        }
        String this$dropSingleColumnOption = this.getDropSingleColumnOption();
        String other$dropSingleColumnOption = other.getDropSingleColumnOption();
        if (this$dropSingleColumnOption == null ? other$dropSingleColumnOption != null : !this$dropSingleColumnOption.equals(other$dropSingleColumnOption)) {
            return false;
        }
        List<ColumnDefinition> this$modifyColumns = this.getModifyColumns();
        List<ColumnDefinition> other$modifyColumns = other.getModifyColumns();
        if (this$modifyColumns == null ? other$modifyColumns != null : !((Object)this$modifyColumns).equals(other$modifyColumns)) {
            return false;
        }
        ColumnReference this$renameFromColumn = this.getRenameFromColumn();
        ColumnReference other$renameFromColumn = other.getRenameFromColumn();
        if (this$renameFromColumn == null ? other$renameFromColumn != null : !((Object)this$renameFromColumn).equals(other$renameFromColumn)) {
            return false;
        }
        String this$renameToColumnName = this.getRenameToColumnName();
        String other$renameToColumnName = other.getRenameToColumnName();
        if (this$renameToColumnName == null ? other$renameToColumnName != null : !this$renameToColumnName.equals(other$renameToColumnName)) {
            return false;
        }
        Boolean this$dropTableGroup = this.getDropTableGroup();
        Boolean other$dropTableGroup = other.getDropTableGroup();
        if (this$dropTableGroup == null ? other$dropTableGroup != null : !((Object)this$dropTableGroup).equals(other$dropTableGroup)) {
            return false;
        }
        RelationFactor this$renameToTable = this.getRenameToTable();
        RelationFactor other$renameToTable = other.getRenameToTable();
        if (this$renameToTable == null ? other$renameToTable != null : !((Object)this$renameToTable).equals(other$renameToTable)) {
            return false;
        }
        OutOfLineConstraint this$addConstraint = this.getAddConstraint();
        OutOfLineConstraint other$addConstraint = other.getAddConstraint();
        if (this$addConstraint == null ? other$addConstraint != null : !((Object)this$addConstraint).equals(other$addConstraint)) {
            return false;
        }
        String this$alterIndexName = this.getAlterIndexName();
        String other$alterIndexName = other.getAlterIndexName();
        if (this$alterIndexName == null ? other$alterIndexName != null : !this$alterIndexName.equals(other$alterIndexName)) {
            return false;
        }
        Boolean this$alterIndexVisible = this.getAlterIndexVisible();
        Boolean other$alterIndexVisible = other.getAlterIndexVisible();
        if (this$alterIndexVisible == null ? other$alterIndexVisible != null : !((Object)this$alterIndexVisible).equals(other$alterIndexVisible)) {
            return false;
        }
        Integer this$alterIndexParallel = this.getAlterIndexParallel();
        Integer other$alterIndexParallel = other.getAlterIndexParallel();
        if (this$alterIndexParallel == null ? other$alterIndexParallel != null : !((Object)this$alterIndexParallel).equals(other$alterIndexParallel)) {
            return false;
        }
        Boolean this$alterIndexNoParallel = this.getAlterIndexNoParallel();
        Boolean other$alterIndexNoParallel = other.getAlterIndexNoParallel();
        if (this$alterIndexNoParallel == null ? other$alterIndexNoParallel != null : !((Object)this$alterIndexNoParallel).equals(other$alterIndexNoParallel)) {
            return false;
        }
        List<String> this$dropConstraintNames = this.getDropConstraintNames();
        List<String> other$dropConstraintNames = other.getDropConstraintNames();
        if (this$dropConstraintNames == null ? other$dropConstraintNames != null : !((Object)this$dropConstraintNames).equals(other$dropConstraintNames)) {
            return false;
        }
        String this$modifyConstraintName = this.getModifyConstraintName();
        String other$modifyConstraintName = other.getModifyConstraintName();
        if (this$modifyConstraintName == null ? other$modifyConstraintName != null : !this$modifyConstraintName.equals(other$modifyConstraintName)) {
            return false;
        }
        ConstraintState this$modifyConstraintState = this.getModifyConstraintState();
        ConstraintState other$modifyConstraintState = other.getModifyConstraintState();
        if (this$modifyConstraintState == null ? other$modifyConstraintState != null : !((Object)this$modifyConstraintState).equals(other$modifyConstraintState)) {
            return false;
        }
        Boolean this$updateGlobalIndexes = this.getUpdateGlobalIndexes();
        Boolean other$updateGlobalIndexes = other.getUpdateGlobalIndexes();
        if (this$updateGlobalIndexes == null ? other$updateGlobalIndexes != null : !((Object)this$updateGlobalIndexes).equals(other$updateGlobalIndexes)) {
            return false;
        }
        List<String> this$truncatePartitionNames = this.getTruncatePartitionNames();
        List<String> other$truncatePartitionNames = other.getTruncatePartitionNames();
        if (this$truncatePartitionNames == null ? other$truncatePartitionNames != null : !((Object)this$truncatePartitionNames).equals(other$truncatePartitionNames)) {
            return false;
        }
        List<String> this$truncateSubPartitionNames = this.getTruncateSubPartitionNames();
        List<String> other$truncateSubPartitionNames = other.getTruncateSubPartitionNames();
        if (this$truncateSubPartitionNames == null ? other$truncateSubPartitionNames != null : !((Object)this$truncateSubPartitionNames).equals(other$truncateSubPartitionNames)) {
            return false;
        }
        List<String> this$dropPartitionNames = this.getDropPartitionNames();
        List<String> other$dropPartitionNames = other.getDropPartitionNames();
        if (this$dropPartitionNames == null ? other$dropPartitionNames != null : !((Object)this$dropPartitionNames).equals(other$dropPartitionNames)) {
            return false;
        }
        List<String> this$dropSubPartitionNames = this.getDropSubPartitionNames();
        List<String> other$dropSubPartitionNames = other.getDropSubPartitionNames();
        if (this$dropSubPartitionNames == null ? other$dropSubPartitionNames != null : !((Object)this$dropSubPartitionNames).equals(other$dropSubPartitionNames)) {
            return false;
        }
        List<PartitionElement> this$addPartitionElements = this.getAddPartitionElements();
        List<PartitionElement> other$addPartitionElements = other.getAddPartitionElements();
        if (this$addPartitionElements == null ? other$addPartitionElements != null : !((Object)this$addPartitionElements).equals(other$addPartitionElements)) {
            return false;
        }
        RelationFactor this$addSubPartitionElementTo = this.getAddSubPartitionElementTo();
        RelationFactor other$addSubPartitionElementTo = other.getAddSubPartitionElementTo();
        if (this$addSubPartitionElementTo == null ? other$addSubPartitionElementTo != null : !((Object)this$addSubPartitionElementTo).equals(other$addSubPartitionElementTo)) {
            return false;
        }
        List<SubPartitionElement> this$addSubPartitionElements = this.getAddSubPartitionElements();
        List<SubPartitionElement> other$addSubPartitionElements = other.getAddSubPartitionElements();
        if (this$addSubPartitionElements == null ? other$addSubPartitionElements != null : !((Object)this$addSubPartitionElements).equals(other$addSubPartitionElements)) {
            return false;
        }
        Partition this$modifyPartition = this.getModifyPartition();
        Partition other$modifyPartition = other.getModifyPartition();
        if (this$modifyPartition == null ? other$modifyPartition != null : !this$modifyPartition.equals(other$modifyPartition)) {
            return false;
        }
        RelationFactor this$splitPartition = this.getSplitPartition();
        RelationFactor other$splitPartition = other.getSplitPartition();
        if (this$splitPartition == null ? other$splitPartition != null : !((Object)this$splitPartition).equals(other$splitPartition)) {
            return false;
        }
        PartitionSplitActions this$splitActions = this.getSplitActions();
        PartitionSplitActions other$splitActions = other.getSplitActions();
        if (this$splitActions == null ? other$splitActions != null : !((Object)this$splitActions).equals(other$splitActions)) {
            return false;
        }
        Expression this$interval = this.getInterval();
        Expression other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        Boolean this$enableAllTriggers = this.getEnableAllTriggers();
        Boolean other$enableAllTriggers = other.getEnableAllTriggers();
        if (this$enableAllTriggers == null ? other$enableAllTriggers != null : !((Object)this$enableAllTriggers).equals(other$enableAllTriggers)) {
            return false;
        }
        ColumnReference this$alterColumn = this.getAlterColumn();
        ColumnReference other$alterColumn = other.getAlterColumn();
        if (this$alterColumn == null ? other$alterColumn != null : !((Object)this$alterColumn).equals(other$alterColumn)) {
            return false;
        }
        AlterColumnBehavior this$alterColumnBehavior = this.getAlterColumnBehavior();
        AlterColumnBehavior other$alterColumnBehavior = other.getAlterColumnBehavior();
        if (this$alterColumnBehavior == null ? other$alterColumnBehavior != null : !((Object)this$alterColumnBehavior).equals(other$alterColumnBehavior)) {
            return false;
        }
        ColumnReference this$changeColumn = this.getChangeColumn();
        ColumnReference other$changeColumn = other.getChangeColumn();
        if (this$changeColumn == null ? other$changeColumn != null : !((Object)this$changeColumn).equals(other$changeColumn)) {
            return false;
        }
        ColumnDefinition this$changeColumnDefinition = this.getChangeColumnDefinition();
        ColumnDefinition other$changeColumnDefinition = other.getChangeColumnDefinition();
        if (this$changeColumnDefinition == null ? other$changeColumnDefinition != null : !((Object)this$changeColumnDefinition).equals(other$changeColumnDefinition)) {
            return false;
        }
        OutOfLineIndex this$addIndex = this.getAddIndex();
        OutOfLineIndex other$addIndex = other.getAddIndex();
        if (this$addIndex == null ? other$addIndex != null : !((Object)this$addIndex).equals(other$addIndex)) {
            return false;
        }
        String this$dropIndexName = this.getDropIndexName();
        String other$dropIndexName = other.getDropIndexName();
        if (this$dropIndexName == null ? other$dropIndexName != null : !this$dropIndexName.equals(other$dropIndexName)) {
            return false;
        }
        String this$dropForeignKeyName = this.getDropForeignKeyName();
        String other$dropForeignKeyName = other.getDropForeignKeyName();
        if (this$dropForeignKeyName == null ? other$dropForeignKeyName != null : !this$dropForeignKeyName.equals(other$dropForeignKeyName)) {
            return false;
        }
        String this$renameFromIndexName = this.getRenameFromIndexName();
        String other$renameFromIndexName = other.getRenameFromIndexName();
        if (this$renameFromIndexName == null ? other$renameFromIndexName != null : !this$renameFromIndexName.equals(other$renameFromIndexName)) {
            return false;
        }
        String this$renameToIndexName = this.getRenameToIndexName();
        String other$renameToIndexName = other.getRenameToIndexName();
        if (this$renameToIndexName == null ? other$renameToIndexName != null : !this$renameToIndexName.equals(other$renameToIndexName)) {
            return false;
        }
        List<String> this$reorganizePartitionNames = this.getReorganizePartitionNames();
        List<String> other$reorganizePartitionNames = other.getReorganizePartitionNames();
        if (this$reorganizePartitionNames == null ? other$reorganizePartitionNames != null : !((Object)this$reorganizePartitionNames).equals(other$reorganizePartitionNames)) {
            return false;
        }
        List<PartitionElement> this$reorganizePartitionIntos = this.getReorganizePartitionIntos();
        List<PartitionElement> other$reorganizePartitionIntos = other.getReorganizePartitionIntos();
        if (this$reorganizePartitionIntos == null ? other$reorganizePartitionIntos != null : !((Object)this$reorganizePartitionIntos).equals(other$reorganizePartitionIntos)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$collation = this.getCollation();
        String other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !this$collation.equals(other$collation)) {
            return false;
        }
        Boolean this$dropPrimaryKey = this.getDropPrimaryKey();
        Boolean other$dropPrimaryKey = other.getDropPrimaryKey();
        if (this$dropPrimaryKey == null ? other$dropPrimaryKey != null : !((Object)this$dropPrimaryKey).equals(other$dropPrimaryKey)) {
            return false;
        }
        OutOfLineConstraint this$modifyPrimaryKey = this.getModifyPrimaryKey();
        OutOfLineConstraint other$modifyPrimaryKey = other.getModifyPrimaryKey();
        if (this$modifyPrimaryKey == null ? other$modifyPrimaryKey != null : !((Object)this$modifyPrimaryKey).equals(other$modifyPrimaryKey)) {
            return false;
        }
        if (this.isRefresh() != other.isRefresh()) {
            return false;
        }
        String this$renameFromPartitionName = this.getRenameFromPartitionName();
        String other$renameFromPartitionName = other.getRenameFromPartitionName();
        if (this$renameFromPartitionName == null ? other$renameFromPartitionName != null : !this$renameFromPartitionName.equals(other$renameFromPartitionName)) {
            return false;
        }
        String this$renameToPartitionName = this.getRenameToPartitionName();
        String other$renameToPartitionName = other.getRenameToPartitionName();
        if (this$renameToPartitionName == null ? other$renameToPartitionName != null : !this$renameToPartitionName.equals(other$renameToPartitionName)) {
            return false;
        }
        String this$renameFromSubPartitionName = this.getRenameFromSubPartitionName();
        String other$renameFromSubPartitionName = other.getRenameFromSubPartitionName();
        if (this$renameFromSubPartitionName == null ? other$renameFromSubPartitionName != null : !this$renameFromSubPartitionName.equals(other$renameFromSubPartitionName)) {
            return false;
        }
        String this$renameToSubPartitionName = this.getRenameToSubPartitionName();
        String other$renameToSubPartitionName = other.getRenameToSubPartitionName();
        if (this$renameToSubPartitionName == null ? other$renameToSubPartitionName != null : !this$renameToSubPartitionName.equals(other$renameToSubPartitionName)) {
            return false;
        }
        List<ColumnGroupElement> this$addColumnGroupElements = this.getAddColumnGroupElements();
        List<ColumnGroupElement> other$addColumnGroupElements = other.getAddColumnGroupElements();
        if (this$addColumnGroupElements == null ? other$addColumnGroupElements != null : !((Object)this$addColumnGroupElements).equals(other$addColumnGroupElements)) {
            return false;
        }
        List<ColumnGroupElement> this$dropColumnGroupElements = this.getDropColumnGroupElements();
        List<ColumnGroupElement> other$dropColumnGroupElements = other.getDropColumnGroupElements();
        return !(this$dropColumnGroupElements == null ? other$dropColumnGroupElements != null : !((Object)this$dropColumnGroupElements).equals(other$dropColumnGroupElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlterTableAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableOptions $tableOptions = this.getTableOptions();
        result = result * 59 + ($tableOptions == null ? 43 : ((Object)$tableOptions).hashCode());
        Boolean $moveNoCompress = this.getMoveNoCompress();
        result = result * 59 + ($moveNoCompress == null ? 43 : ((Object)$moveNoCompress).hashCode());
        Boolean $removePartitioning = this.getRemovePartitioning();
        result = result * 59 + ($removePartitioning == null ? 43 : ((Object)$removePartitioning).hashCode());
        String $moveCompress = this.getMoveCompress();
        result = result * 59 + ($moveCompress == null ? 43 : $moveCompress.hashCode());
        List<ColumnDefinition> $addColumns = this.getAddColumns();
        result = result * 59 + ($addColumns == null ? 43 : ((Object)$addColumns).hashCode());
        List<ColumnReference> $dropColumns = this.getDropColumns();
        result = result * 59 + ($dropColumns == null ? 43 : ((Object)$dropColumns).hashCode());
        String $dropSingleColumnOption = this.getDropSingleColumnOption();
        result = result * 59 + ($dropSingleColumnOption == null ? 43 : $dropSingleColumnOption.hashCode());
        List<ColumnDefinition> $modifyColumns = this.getModifyColumns();
        result = result * 59 + ($modifyColumns == null ? 43 : ((Object)$modifyColumns).hashCode());
        ColumnReference $renameFromColumn = this.getRenameFromColumn();
        result = result * 59 + ($renameFromColumn == null ? 43 : ((Object)$renameFromColumn).hashCode());
        String $renameToColumnName = this.getRenameToColumnName();
        result = result * 59 + ($renameToColumnName == null ? 43 : $renameToColumnName.hashCode());
        Boolean $dropTableGroup = this.getDropTableGroup();
        result = result * 59 + ($dropTableGroup == null ? 43 : ((Object)$dropTableGroup).hashCode());
        RelationFactor $renameToTable = this.getRenameToTable();
        result = result * 59 + ($renameToTable == null ? 43 : ((Object)$renameToTable).hashCode());
        OutOfLineConstraint $addConstraint = this.getAddConstraint();
        result = result * 59 + ($addConstraint == null ? 43 : ((Object)$addConstraint).hashCode());
        String $alterIndexName = this.getAlterIndexName();
        result = result * 59 + ($alterIndexName == null ? 43 : $alterIndexName.hashCode());
        Boolean $alterIndexVisible = this.getAlterIndexVisible();
        result = result * 59 + ($alterIndexVisible == null ? 43 : ((Object)$alterIndexVisible).hashCode());
        Integer $alterIndexParallel = this.getAlterIndexParallel();
        result = result * 59 + ($alterIndexParallel == null ? 43 : ((Object)$alterIndexParallel).hashCode());
        Boolean $alterIndexNoParallel = this.getAlterIndexNoParallel();
        result = result * 59 + ($alterIndexNoParallel == null ? 43 : ((Object)$alterIndexNoParallel).hashCode());
        List<String> $dropConstraintNames = this.getDropConstraintNames();
        result = result * 59 + ($dropConstraintNames == null ? 43 : ((Object)$dropConstraintNames).hashCode());
        String $modifyConstraintName = this.getModifyConstraintName();
        result = result * 59 + ($modifyConstraintName == null ? 43 : $modifyConstraintName.hashCode());
        ConstraintState $modifyConstraintState = this.getModifyConstraintState();
        result = result * 59 + ($modifyConstraintState == null ? 43 : ((Object)$modifyConstraintState).hashCode());
        Boolean $updateGlobalIndexes = this.getUpdateGlobalIndexes();
        result = result * 59 + ($updateGlobalIndexes == null ? 43 : ((Object)$updateGlobalIndexes).hashCode());
        List<String> $truncatePartitionNames = this.getTruncatePartitionNames();
        result = result * 59 + ($truncatePartitionNames == null ? 43 : ((Object)$truncatePartitionNames).hashCode());
        List<String> $truncateSubPartitionNames = this.getTruncateSubPartitionNames();
        result = result * 59 + ($truncateSubPartitionNames == null ? 43 : ((Object)$truncateSubPartitionNames).hashCode());
        List<String> $dropPartitionNames = this.getDropPartitionNames();
        result = result * 59 + ($dropPartitionNames == null ? 43 : ((Object)$dropPartitionNames).hashCode());
        List<String> $dropSubPartitionNames = this.getDropSubPartitionNames();
        result = result * 59 + ($dropSubPartitionNames == null ? 43 : ((Object)$dropSubPartitionNames).hashCode());
        List<PartitionElement> $addPartitionElements = this.getAddPartitionElements();
        result = result * 59 + ($addPartitionElements == null ? 43 : ((Object)$addPartitionElements).hashCode());
        RelationFactor $addSubPartitionElementTo = this.getAddSubPartitionElementTo();
        result = result * 59 + ($addSubPartitionElementTo == null ? 43 : ((Object)$addSubPartitionElementTo).hashCode());
        List<SubPartitionElement> $addSubPartitionElements = this.getAddSubPartitionElements();
        result = result * 59 + ($addSubPartitionElements == null ? 43 : ((Object)$addSubPartitionElements).hashCode());
        Partition $modifyPartition = this.getModifyPartition();
        result = result * 59 + ($modifyPartition == null ? 43 : $modifyPartition.hashCode());
        RelationFactor $splitPartition = this.getSplitPartition();
        result = result * 59 + ($splitPartition == null ? 43 : ((Object)$splitPartition).hashCode());
        PartitionSplitActions $splitActions = this.getSplitActions();
        result = result * 59 + ($splitActions == null ? 43 : ((Object)$splitActions).hashCode());
        Expression $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        Boolean $enableAllTriggers = this.getEnableAllTriggers();
        result = result * 59 + ($enableAllTriggers == null ? 43 : ((Object)$enableAllTriggers).hashCode());
        ColumnReference $alterColumn = this.getAlterColumn();
        result = result * 59 + ($alterColumn == null ? 43 : ((Object)$alterColumn).hashCode());
        AlterColumnBehavior $alterColumnBehavior = this.getAlterColumnBehavior();
        result = result * 59 + ($alterColumnBehavior == null ? 43 : ((Object)$alterColumnBehavior).hashCode());
        ColumnReference $changeColumn = this.getChangeColumn();
        result = result * 59 + ($changeColumn == null ? 43 : ((Object)$changeColumn).hashCode());
        ColumnDefinition $changeColumnDefinition = this.getChangeColumnDefinition();
        result = result * 59 + ($changeColumnDefinition == null ? 43 : ((Object)$changeColumnDefinition).hashCode());
        OutOfLineIndex $addIndex = this.getAddIndex();
        result = result * 59 + ($addIndex == null ? 43 : ((Object)$addIndex).hashCode());
        String $dropIndexName = this.getDropIndexName();
        result = result * 59 + ($dropIndexName == null ? 43 : $dropIndexName.hashCode());
        String $dropForeignKeyName = this.getDropForeignKeyName();
        result = result * 59 + ($dropForeignKeyName == null ? 43 : $dropForeignKeyName.hashCode());
        String $renameFromIndexName = this.getRenameFromIndexName();
        result = result * 59 + ($renameFromIndexName == null ? 43 : $renameFromIndexName.hashCode());
        String $renameToIndexName = this.getRenameToIndexName();
        result = result * 59 + ($renameToIndexName == null ? 43 : $renameToIndexName.hashCode());
        List<String> $reorganizePartitionNames = this.getReorganizePartitionNames();
        result = result * 59 + ($reorganizePartitionNames == null ? 43 : ((Object)$reorganizePartitionNames).hashCode());
        List<PartitionElement> $reorganizePartitionIntos = this.getReorganizePartitionIntos();
        result = result * 59 + ($reorganizePartitionIntos == null ? 43 : ((Object)$reorganizePartitionIntos).hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : $collation.hashCode());
        Boolean $dropPrimaryKey = this.getDropPrimaryKey();
        result = result * 59 + ($dropPrimaryKey == null ? 43 : ((Object)$dropPrimaryKey).hashCode());
        OutOfLineConstraint $modifyPrimaryKey = this.getModifyPrimaryKey();
        result = result * 59 + ($modifyPrimaryKey == null ? 43 : ((Object)$modifyPrimaryKey).hashCode());
        result = result * 59 + (this.isRefresh() ? 79 : 97);
        String $renameFromPartitionName = this.getRenameFromPartitionName();
        result = result * 59 + ($renameFromPartitionName == null ? 43 : $renameFromPartitionName.hashCode());
        String $renameToPartitionName = this.getRenameToPartitionName();
        result = result * 59 + ($renameToPartitionName == null ? 43 : $renameToPartitionName.hashCode());
        String $renameFromSubPartitionName = this.getRenameFromSubPartitionName();
        result = result * 59 + ($renameFromSubPartitionName == null ? 43 : $renameFromSubPartitionName.hashCode());
        String $renameToSubPartitionName = this.getRenameToSubPartitionName();
        result = result * 59 + ($renameToSubPartitionName == null ? 43 : $renameToSubPartitionName.hashCode());
        List<ColumnGroupElement> $addColumnGroupElements = this.getAddColumnGroupElements();
        result = result * 59 + ($addColumnGroupElements == null ? 43 : ((Object)$addColumnGroupElements).hashCode());
        List<ColumnGroupElement> $dropColumnGroupElements = this.getDropColumnGroupElements();
        result = result * 59 + ($dropColumnGroupElements == null ? 43 : ((Object)$dropColumnGroupElements).hashCode());
        return result;
    }

    public static class AlterColumnBehavior
    extends BaseStatement {
        private Expression defaultValue;

        public AlterColumnBehavior(@NonNull ParserRuleContext context) {
            super(context);
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
        }

        public boolean isDropDefault() {
            return this.defaultValue == null;
        }

        public boolean isSetDefault() {
            return this.defaultValue != null;
        }

        public String toString() {
            return this.isSetDefault() ? "SET DEFAULT" + this.defaultValue : "DROP DEFAULT";
        }

        public Expression getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Expression defaultValue) {
            this.defaultValue = defaultValue;
        }

        public AlterColumnBehavior() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlterColumnBehavior)) {
                return false;
            }
            AlterColumnBehavior other = (AlterColumnBehavior)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expression this$defaultValue = this.getDefaultValue();
            Expression other$defaultValue = other.getDefaultValue();
            return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlterColumnBehavior;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expression $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            return result;
        }
    }
}

