/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common.oracle;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.select.Projection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class Returning
extends BaseStatement {
    private boolean bulkCollect;
    private final List<Expression> intoList;
    private final List<Projection> expressionList;

    public Returning(@NonNull ParserRuleContext context, @NonNull List<Expression> intoList, @NonNull List<Projection> expressionList) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (intoList == null) {
            throw new NullPointerException("intoList is marked non-null but is null");
        }
        if (expressionList == null) {
            throw new NullPointerException("expressionList is marked non-null but is null");
        }
        this.intoList = intoList;
        this.expressionList = expressionList;
    }

    public Returning(@NonNull List<Expression> intoList, @NonNull List<Projection> expressionList) {
        if (intoList == null) {
            throw new NullPointerException("intoList is marked non-null but is null");
        }
        if (expressionList == null) {
            throw new NullPointerException("expressionList is marked non-null but is null");
        }
        this.intoList = intoList;
        this.expressionList = expressionList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RETURNING ").append(this.expressionList.stream().map(Projection::toString).collect(Collectors.joining(",")));
        if (CollectionUtils.isNotEmpty(this.intoList)) {
            if (this.bulkCollect) {
                builder.append(" BULK COLLECT");
            }
            builder.append(" INTO ").append(this.intoList.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        return builder.toString();
    }

    public boolean isBulkCollect() {
        return this.bulkCollect;
    }

    public List<Expression> getIntoList() {
        return this.intoList;
    }

    public List<Projection> getExpressionList() {
        return this.expressionList;
    }

    public void setBulkCollect(boolean bulkCollect) {
        this.bulkCollect = bulkCollect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Returning)) {
            return false;
        }
        Returning other = (Returning)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBulkCollect() != other.isBulkCollect()) {
            return false;
        }
        List<Expression> this$intoList = this.getIntoList();
        List<Expression> other$intoList = other.getIntoList();
        if (this$intoList == null ? other$intoList != null : !((Object)this$intoList).equals(other$intoList)) {
            return false;
        }
        List<Projection> this$expressionList = this.getExpressionList();
        List<Projection> other$expressionList = other.getExpressionList();
        return !(this$expressionList == null ? other$expressionList != null : !((Object)this$expressionList).equals(other$expressionList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Returning;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBulkCollect() ? 79 : 97);
        List<Expression> $intoList = this.getIntoList();
        result = result * 59 + ($intoList == null ? 43 : ((Object)$intoList).hashCode());
        List<Projection> $expressionList = this.getExpressionList();
        result = result * 59 + ($expressionList == null ? 43 : ((Object)$expressionList).hashCode());
        return result;
    }
}

