/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createindex;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createtable.IndexOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class CreateIndex
extends BaseStatement {
    private boolean fullText;
    private boolean spatial;
    private boolean unique;
    private boolean ifNotExists;
    private RelationFactor on;
    private RelationFactor relation;
    private IndexOptions indexOptions;
    private Partition partition;
    private final List<SortColumn> columns;
    private List<ColumnGroupElement> columnGroupElements;

    public CreateIndex(@NonNull ParserRuleContext context, @NonNull RelationFactor relation, @NonNull RelationFactor on, @NonNull List<SortColumn> columns) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        if (on == null) {
            throw new NullPointerException("on is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.on = on;
        this.relation = relation;
        this.columns = columns;
    }

    public CreateIndex(@NonNull RelationFactor relation, @NonNull RelationFactor on, @NonNull List<SortColumn> columns) {
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        if (on == null) {
            throw new NullPointerException("on is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.on = on;
        this.relation = relation;
        this.columns = columns;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CREATE");
        if (this.unique) {
            builder.append(" UNIQUE");
        }
        if (this.fullText) {
            builder.append(" FULLTEXT");
        }
        if (this.spatial) {
            builder.append(" SPATIAL");
        }
        builder.append(" INDEX");
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        builder.append(" ").append(this.relation).append(" ON ").append(this.on).append(" (\n\t").append(this.columns.stream().map(SortColumn::toString).collect(Collectors.joining(",\n\t"))).append("\n)");
        if (this.indexOptions != null) {
            builder.append(" ").append(this.indexOptions);
        }
        if (this.partition != null) {
            builder.append("\n").append(this.partition);
        }
        if (this.columnGroupElements != null) {
            builder.append(" WITH COLUMN GROUP(").append(this.columnGroupElements.stream().map(ColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        return builder.toString();
    }

    public boolean isFullText() {
        return this.fullText;
    }

    public boolean isSpatial() {
        return this.spatial;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public RelationFactor getOn() {
        return this.on;
    }

    public RelationFactor getRelation() {
        return this.relation;
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public List<SortColumn> getColumns() {
        return this.columns;
    }

    public List<ColumnGroupElement> getColumnGroupElements() {
        return this.columnGroupElements;
    }

    public void setFullText(boolean fullText) {
        this.fullText = fullText;
    }

    public void setSpatial(boolean spatial) {
        this.spatial = spatial;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setOn(RelationFactor on) {
        this.on = on;
    }

    public void setRelation(RelationFactor relation) {
        this.relation = relation;
    }

    public void setIndexOptions(IndexOptions indexOptions) {
        this.indexOptions = indexOptions;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public void setColumnGroupElements(List<ColumnGroupElement> columnGroupElements) {
        this.columnGroupElements = columnGroupElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateIndex)) {
            return false;
        }
        CreateIndex other = (CreateIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFullText() != other.isFullText()) {
            return false;
        }
        if (this.isSpatial() != other.isSpatial()) {
            return false;
        }
        if (this.isUnique() != other.isUnique()) {
            return false;
        }
        if (this.isIfNotExists() != other.isIfNotExists()) {
            return false;
        }
        RelationFactor this$on = this.getOn();
        RelationFactor other$on = other.getOn();
        if (this$on == null ? other$on != null : !((Object)this$on).equals(other$on)) {
            return false;
        }
        RelationFactor this$relation = this.getRelation();
        RelationFactor other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !((Object)this$relation).equals(other$relation)) {
            return false;
        }
        IndexOptions this$indexOptions = this.getIndexOptions();
        IndexOptions other$indexOptions = other.getIndexOptions();
        if (this$indexOptions == null ? other$indexOptions != null : !((Object)this$indexOptions).equals(other$indexOptions)) {
            return false;
        }
        Partition this$partition = this.getPartition();
        Partition other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        List<SortColumn> this$columns = this.getColumns();
        List<SortColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<ColumnGroupElement> this$columnGroupElements = this.getColumnGroupElements();
        List<ColumnGroupElement> other$columnGroupElements = other.getColumnGroupElements();
        return !(this$columnGroupElements == null ? other$columnGroupElements != null : !((Object)this$columnGroupElements).equals(other$columnGroupElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFullText() ? 79 : 97);
        result = result * 59 + (this.isSpatial() ? 79 : 97);
        result = result * 59 + (this.isUnique() ? 79 : 97);
        result = result * 59 + (this.isIfNotExists() ? 79 : 97);
        RelationFactor $on = this.getOn();
        result = result * 59 + ($on == null ? 43 : ((Object)$on).hashCode());
        RelationFactor $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : ((Object)$relation).hashCode());
        IndexOptions $indexOptions = this.getIndexOptions();
        result = result * 59 + ($indexOptions == null ? 43 : ((Object)$indexOptions).hashCode());
        Partition $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        List<SortColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<ColumnGroupElement> $columnGroupElements = this.getColumnGroupElements();
        result = result * 59 + ($columnGroupElements == null ? 43 : ((Object)$columnGroupElements).hashCode());
        return result;
    }
}

