/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnDefinition;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineIndex;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.TableElement;
import com.oceanbase.tools.sqlparser.statement.createtable.TableOptions;
import com.oceanbase.tools.sqlparser.statement.select.Select;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class CreateTable
extends BaseStatement {
    private RelationFactor relation;
    private String userVariable;
    private boolean global;
    private boolean temporary;
    private boolean external;
    private Select as;
    private List<TableElement> tableElements;
    private TableOptions tableOptions;
    private boolean ifNotExists;
    private RelationFactor likeTable;
    private String commitOption;
    private Partition partition;
    private List<ColumnGroupElement> columnGroupElements;

    public CreateTable(@NonNull ParserRuleContext context, @NonNull RelationFactor relation) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.relation = relation;
    }

    public CreateTable(@NonNull RelationFactor relation) {
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.relation = relation;
    }

    public String getSchema() {
        if (this.relation == null) {
            return null;
        }
        return this.relation.getSchema();
    }

    public String getTableName() {
        if (this.relation == null) {
            return null;
        }
        return this.relation.getRelation();
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        if (CollectionUtils.isEmpty(this.tableElements)) {
            return Collections.emptyList();
        }
        return this.tableElements.stream().filter(t -> t instanceof ColumnDefinition).map(t -> (ColumnDefinition)t).collect(Collectors.toList());
    }

    public List<OutOfLineIndex> getIndexes() {
        if (CollectionUtils.isEmpty(this.tableElements)) {
            return Collections.emptyList();
        }
        return this.tableElements.stream().filter(t -> t instanceof OutOfLineIndex).map(t -> (OutOfLineIndex)t).collect(Collectors.toList());
    }

    public List<OutOfLineConstraint> getConstraints() {
        if (CollectionUtils.isEmpty(this.tableElements)) {
            return Collections.emptyList();
        }
        return this.tableElements.stream().filter(t -> t instanceof OutOfLineConstraint).map(t -> (OutOfLineConstraint)t).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CREATE");
        if (this.global) {
            builder.append(" GLOBAL");
        }
        if (this.temporary) {
            builder.append(" TEMPORARY");
        }
        if (this.external) {
            builder.append(" EXTERNAL");
        }
        builder.append(" TABLE");
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (this.getSchema() != null) {
            builder.append(" ").append(this.getSchema()).append(".").append(this.getTableName());
        } else {
            builder.append(" ").append(this.getTableName());
        }
        if (this.userVariable != null) {
            builder.append(this.userVariable);
        }
        if (this.likeTable != null) {
            builder.append(" LIKE ").append(this.likeTable);
            return builder.toString();
        }
        if (CollectionUtils.isNotEmpty(this.tableElements)) {
            builder.append(" (");
            List<ColumnDefinition> definitions = this.getColumnDefinitions();
            List<OutOfLineIndex> indexList = this.getIndexes();
            List<OutOfLineConstraint> constraints = this.getConstraints();
            if (!definitions.isEmpty()) {
                builder.append("\n\t").append(definitions.stream().map(ColumnDefinition::toString).collect(Collectors.joining(",\n\t")));
                if (!indexList.isEmpty() || !constraints.isEmpty()) {
                    builder.append(",");
                }
            }
            if (!indexList.isEmpty()) {
                builder.append("\n\t").append(indexList.stream().map(OutOfLineIndex::toString).collect(Collectors.joining(",\n\t")));
                if (!constraints.isEmpty()) {
                    builder.append(",");
                }
            }
            if (!constraints.isEmpty()) {
                builder.append("\n\t").append(constraints.stream().map(OutOfLineConstraint::toString).collect(Collectors.joining(",\n\t")));
            }
            builder.append("\n)");
        }
        if (this.tableOptions != null) {
            builder.append(" ").append(this.tableOptions);
        }
        if (this.partition != null) {
            builder.append("\n").append(this.partition).append("\n");
        }
        if (this.commitOption != null) {
            builder.append(" ON COMMIT ").append(this.commitOption.toUpperCase()).append(" ROWS");
        }
        if (this.columnGroupElements != null) {
            builder.append(" WITH COLUMN GROUP(").append(this.columnGroupElements.stream().map(ColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.as != null) {
            builder.append(" AS ").append(this.as);
        }
        return builder.toString();
    }

    public RelationFactor getRelation() {
        return this.relation;
    }

    public String getUserVariable() {
        return this.userVariable;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isExternal() {
        return this.external;
    }

    public Select getAs() {
        return this.as;
    }

    public List<TableElement> getTableElements() {
        return this.tableElements;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public RelationFactor getLikeTable() {
        return this.likeTable;
    }

    public String getCommitOption() {
        return this.commitOption;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public List<ColumnGroupElement> getColumnGroupElements() {
        return this.columnGroupElements;
    }

    public void setRelation(RelationFactor relation) {
        this.relation = relation;
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setAs(Select as) {
        this.as = as;
    }

    public void setTableElements(List<TableElement> tableElements) {
        this.tableElements = tableElements;
    }

    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setLikeTable(RelationFactor likeTable) {
        this.likeTable = likeTable;
    }

    public void setCommitOption(String commitOption) {
        this.commitOption = commitOption;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public void setColumnGroupElements(List<ColumnGroupElement> columnGroupElements) {
        this.columnGroupElements = columnGroupElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTable)) {
            return false;
        }
        CreateTable other = (CreateTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationFactor this$relation = this.getRelation();
        RelationFactor other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !((Object)this$relation).equals(other$relation)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        if (this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable)) {
            return false;
        }
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        if (this.isTemporary() != other.isTemporary()) {
            return false;
        }
        if (this.isExternal() != other.isExternal()) {
            return false;
        }
        Select this$as = this.getAs();
        Select other$as = other.getAs();
        if (this$as == null ? other$as != null : !((Object)this$as).equals(other$as)) {
            return false;
        }
        List<TableElement> this$tableElements = this.getTableElements();
        List<TableElement> other$tableElements = other.getTableElements();
        if (this$tableElements == null ? other$tableElements != null : !((Object)this$tableElements).equals(other$tableElements)) {
            return false;
        }
        TableOptions this$tableOptions = this.getTableOptions();
        TableOptions other$tableOptions = other.getTableOptions();
        if (this$tableOptions == null ? other$tableOptions != null : !((Object)this$tableOptions).equals(other$tableOptions)) {
            return false;
        }
        if (this.isIfNotExists() != other.isIfNotExists()) {
            return false;
        }
        RelationFactor this$likeTable = this.getLikeTable();
        RelationFactor other$likeTable = other.getLikeTable();
        if (this$likeTable == null ? other$likeTable != null : !((Object)this$likeTable).equals(other$likeTable)) {
            return false;
        }
        String this$commitOption = this.getCommitOption();
        String other$commitOption = other.getCommitOption();
        if (this$commitOption == null ? other$commitOption != null : !this$commitOption.equals(other$commitOption)) {
            return false;
        }
        Partition this$partition = this.getPartition();
        Partition other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        List<ColumnGroupElement> this$columnGroupElements = this.getColumnGroupElements();
        List<ColumnGroupElement> other$columnGroupElements = other.getColumnGroupElements();
        return !(this$columnGroupElements == null ? other$columnGroupElements != null : !((Object)this$columnGroupElements).equals(other$columnGroupElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationFactor $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : ((Object)$relation).hashCode());
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        result = result * 59 + (this.isGlobal() ? 79 : 97);
        result = result * 59 + (this.isTemporary() ? 79 : 97);
        result = result * 59 + (this.isExternal() ? 79 : 97);
        Select $as = this.getAs();
        result = result * 59 + ($as == null ? 43 : ((Object)$as).hashCode());
        List<TableElement> $tableElements = this.getTableElements();
        result = result * 59 + ($tableElements == null ? 43 : ((Object)$tableElements).hashCode());
        TableOptions $tableOptions = this.getTableOptions();
        result = result * 59 + ($tableOptions == null ? 43 : ((Object)$tableOptions).hashCode());
        result = result * 59 + (this.isIfNotExists() ? 79 : 97);
        RelationFactor $likeTable = this.getLikeTable();
        result = result * 59 + ($likeTable == null ? 43 : ((Object)$likeTable).hashCode());
        String $commitOption = this.getCommitOption();
        result = result * 59 + ($commitOption == null ? 43 : $commitOption.hashCode());
        Partition $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        List<ColumnGroupElement> $columnGroupElements = this.getColumnGroupElements();
        result = result * 59 + ($columnGroupElements == null ? 43 : ((Object)$columnGroupElements).hashCode());
        return result;
    }
}

