/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.BasePartition;
import com.oceanbase.tools.sqlparser.statement.createtable.RangePartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class RangePartition
extends BasePartition {
    private boolean auto;
    private Expression partitionSize;
    private Expression interval;
    private boolean columns;

    public RangePartition(@NonNull ParserRuleContext context, List<Expression> targets, List<RangePartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum, boolean columns) {
        super(context, targets, partitionElements, subPartitionOption, partitionsNum);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.columns = columns;
    }

    public RangePartition(List<Expression> targets, List<RangePartitionElement> partitionElements, SubPartitionOption subPartitionOption, Integer partitionsNum, boolean columns) {
        super(targets, partitionElements, subPartitionOption, partitionsNum);
        this.columns = columns;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PARTITION BY RANGE");
        if (this.columns) {
            builder.append(" COLUMNS");
        }
        builder.append("(");
        if (this.getPartitionTargets() != null) {
            builder.append(this.getPartitionTargets().stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        builder.append(")");
        if (this.interval != null) {
            builder.append(" INTERVAL(").append(this.interval).append(")");
        }
        if (this.getSubPartitionOption() != null) {
            builder.append(" ").append(this.getSubPartitionOption());
        }
        if (this.getPartitionsNum() != null) {
            builder.append(" PARTITIONS ").append(this.getPartitionsNum());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getPartitionElements())) {
            builder.append(" (\n\t").append(this.getPartitionElements().stream().map(Object::toString).collect(Collectors.joining(",\n\t"))).append("\n)");
        }
        if (this.partitionSize != null) {
            builder.append(" PARTITION SIZE ").append(this.partitionSize);
        }
        if (this.auto) {
            builder.append(" PARTITIONS AUTO");
        }
        return builder.toString();
    }

    public boolean isAuto() {
        return this.auto;
    }

    public Expression getPartitionSize() {
        return this.partitionSize;
    }

    public Expression getInterval() {
        return this.interval;
    }

    public boolean isColumns() {
        return this.columns;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public void setPartitionSize(Expression partitionSize) {
        this.partitionSize = partitionSize;
    }

    public void setInterval(Expression interval) {
        this.interval = interval;
    }

    public void setColumns(boolean columns) {
        this.columns = columns;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangePartition)) {
            return false;
        }
        RangePartition other = (RangePartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAuto() != other.isAuto()) {
            return false;
        }
        Expression this$partitionSize = this.getPartitionSize();
        Expression other$partitionSize = other.getPartitionSize();
        if (this$partitionSize == null ? other$partitionSize != null : !this$partitionSize.equals(other$partitionSize)) {
            return false;
        }
        Expression this$interval = this.getInterval();
        Expression other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
            return false;
        }
        return this.isColumns() == other.isColumns();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RangePartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAuto() ? 79 : 97);
        Expression $partitionSize = this.getPartitionSize();
        result = result * 59 + ($partitionSize == null ? 43 : $partitionSize.hashCode());
        Expression $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
        result = result * 59 + (this.isColumns() ? 79 : 97);
        return result;
    }
}

