/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.dropindex;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class DropIndex
extends BaseStatement {
    private final String indexName;
    private final String schemaName;
    private RelationFactor relation;

    public DropIndex(@NonNull ParserRuleContext context, @NonNull String indexName, @NonNull RelationFactor relation) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.indexName = indexName;
        this.relation = relation;
        this.schemaName = relation.getSchema();
    }

    public DropIndex(@NonNull ParserRuleContext context, String schemaName, @NonNull String indexName) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        this.indexName = indexName;
        this.schemaName = schemaName;
    }

    public DropIndex(@NonNull String indexName, @NonNull RelationFactor relation) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.indexName = indexName;
        this.relation = relation;
        this.schemaName = relation.getSchema();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DROP INDEX ");
        if (this.schemaName != null) {
            sb.append(this.schemaName).append(".");
        }
        if (this.indexName != null) {
            sb.append(this.indexName);
        }
        if (this.relation != null) {
            sb.append(" ON ").append(this.relation);
        }
        return sb.toString();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public RelationFactor getRelation() {
        return this.relation;
    }

    public void setRelation(RelationFactor relation) {
        this.relation = relation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropIndex)) {
            return false;
        }
        DropIndex other = (DropIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        RelationFactor this$relation = this.getRelation();
        RelationFactor other$relation = other.getRelation();
        return !(this$relation == null ? other$relation != null : !((Object)this$relation).equals(other$relation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        RelationFactor $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : ((Object)$relation).hashCode());
        return result;
    }
}

