/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.result;

import com.alipay.oceanbase.hbase.util.OHBaseFuncUtils;
import com.alipay.oceanbase.hbase.util.TableHBaseLoggerFactory;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryAsyncStreamResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class ClientStreamScanner
extends AbstractClientScanner {
    private static final Logger logger = TableHBaseLoggerFactory.getLogger(ClientStreamScanner.class);
    private final AbstractQueryStreamResult streamResult;
    private final String tableName;
    private byte[] family;
    protected final Scan scan;
    protected int lineCount = 0;
    private boolean closed = false;
    private boolean isTableGroup = false;

    public ClientStreamScanner(ObTableClientQueryStreamResult streamResult, String tableName, Scan scan, boolean isTableGroup) {
        this.streamResult = streamResult;
        this.tableName = tableName;
        this.scan = scan;
        this.family = isTableGroup ? null : (byte[])scan.getFamilyMap().entrySet().iterator().next().getKey();
        this.isTableGroup = isTableGroup;
    }

    public ClientStreamScanner(ObTableClientQueryAsyncStreamResult streamResult, String tableName, Scan scan, boolean isTableGroup) {
        this.streamResult = streamResult;
        this.tableName = tableName;
        this.scan = scan;
        this.family = isTableGroup ? null : (byte[])scan.getFamilyMap().entrySet().iterator().next().getKey();
        this.isTableGroup = isTableGroup;
    }

    public Result next() throws IOException {
        try {
            if (this.scan.getLimit() > 0 && this.lineCount++ >= this.scan.getLimit()) {
                this.close();
                return null;
            }
            this.checkStatus();
            if (!this.streamResult.next()) {
                return null;
            }
            List startRow = this.streamResult.getRow();
            Object familyAndQualifier = new byte[2][];
            if (this.isTableGroup) {
                familyAndQualifier = OHBaseFuncUtils.extractFamilyFromQualifier((byte[])((ObObj)startRow.get(1)).getValue());
                this.family = familyAndQualifier[0];
            } else {
                familyAndQualifier[1] = (byte[])((ObObj)startRow.get(1)).getValue();
            }
            byte[] sk = (byte[])((ObObj)startRow.get(0)).getValue();
            byte[] sq = familyAndQualifier[1];
            long st = (Long)((ObObj)startRow.get(2)).getValue();
            byte[] sv = (byte[])((ObObj)startRow.get(3)).getValue();
            KeyValue startKeyValue = new KeyValue(sk, this.family, sq, st, sv);
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
            keyValues.add(startKeyValue);
            while (!this.streamResult.getCacheRows().isEmpty() && this.streamResult.next()) {
                List row = this.streamResult.getRow();
                if (this.isTableGroup) {
                    familyAndQualifier = OHBaseFuncUtils.extractFamilyFromQualifier((byte[])((ObObj)row.get(1)).getValue());
                    this.family = familyAndQualifier[0];
                } else {
                    familyAndQualifier[1] = (byte[])((ObObj)row.get(1)).getValue();
                }
                byte[] k = (byte[])((ObObj)row.get(0)).getValue();
                byte[] q = familyAndQualifier[1];
                long t = (Long)((ObObj)row.get(2)).getValue();
                byte[] v = (byte[])((ObObj)row.get(3)).getValue();
                if (Arrays.equals(sk, k)) {
                    keyValues.add(new KeyValue(k, this.family, q, t, v));
                    continue;
                }
                this.streamResult.getCacheRows().addFirst(row);
                break;
            }
            return Result.create(keyValues);
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00000"), (Object)this.streamResult.getTableName(), (Object)e);
            throw new IOException(String.format("get table %s stream next result error ", this.streamResult.getTableName()), e);
        }
    }

    public Result[] next(int nbRows) throws IOException {
        Result next;
        ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
        for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
            resultSets.add(next);
        }
        return resultSets.toArray(new Result[resultSets.size()]);
    }

    public boolean renewLease() {
        try {
            this.streamResult.renewLease();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkStatus() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("table " + this.tableName + " family " + Bytes.toString((byte[])this.family) + " scanner is  closed");
        }
    }

    public void close() {
        try {
            this.closed = true;
            this.streamResult.close();
        }
        catch (Exception e) {
            logger.error(TableHBaseLoggerFactory.LCD.convert("01-00001"), (Object)this.streamResult.getTableName(), (Object)e);
        }
    }
}

