/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.util;

import com.alipay.oceanbase.hbase.OHTable;
import com.alipay.oceanbase.hbase.util.OHConnectionConfiguration;
import com.alipay.oceanbase.hbase.util.OHConnectionImpl;
import com.alipay.oceanbase.hbase.util.TableHBaseLoggerFactory;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class OHBufferedMutatorImpl
implements BufferedMutator {
    private static final Logger LOGGER = TableHBaseLoggerFactory.getLogger(OHBufferedMutatorImpl.class);
    private final BufferedMutator.ExceptionListener listener;
    private final OHTable ohTable;
    private final TableName tableName;
    private volatile Configuration conf;
    private final OHConnectionConfiguration connectionConfig;
    private final ConcurrentLinkedQueue<Mutation> asyncWriteBuffer = new ConcurrentLinkedQueue();
    private final AtomicLong currentAsyncBufferSize = new AtomicLong(0L);
    private final AtomicLong firstRecordInBufferTimestamp = new AtomicLong(0L);
    private final AtomicLong executedWriteBufferPeriodicFlushes = new AtomicLong(0L);
    private final AtomicLong writeBufferPeriodicFlushTimeoutMs = new AtomicLong(0L);
    private final AtomicLong writeBufferPeriodicFlushTimerTickMs = new AtomicLong(100L);
    private Timer writeBufferPeriodicFlushTimer = null;
    private final long writeBufferSize;
    private final int maxKeyValueSize;
    private final ExecutorService pool;
    private final AtomicInteger undealtMutationCount = new AtomicInteger(0);
    private final AtomicInteger rpcTimeout;
    private final AtomicInteger operationTimeout;
    private final boolean cleanupPoolOnClose;
    private volatile boolean closed = false;

    public OHBufferedMutatorImpl(OHConnectionImpl ohConnection, BufferedMutatorParams params) throws IOException {
        if (ohConnection == null || ohConnection.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = params.getTableName();
        this.conf = ohConnection.getConfiguration();
        this.connectionConfig = ohConnection.getOHConnectionConfiguration();
        this.listener = params.getListener();
        if (params.getPool() == null) {
            this.pool = HTable.getDefaultExecutor((Configuration)this.conf);
            this.cleanupPoolOnClose = true;
        } else {
            this.pool = params.getPool();
            this.cleanupPoolOnClose = false;
        }
        this.rpcTimeout = new AtomicInteger(params.getRpcTimeout() != -1 ? params.getRpcTimeout() : this.connectionConfig.getRpcTimeout());
        this.operationTimeout = new AtomicInteger(params.getOperationTimeout() != -1 ? params.getOperationTimeout() : this.connectionConfig.getOperationTimeout());
        long newPeriodicFlushTimeoutMs = params.getWriteBufferPeriodicFlushTimeoutMs() != -1L ? params.getWriteBufferPeriodicFlushTimeoutMs() : this.connectionConfig.getWriteBufferPeriodicFlushTimeoutMs();
        long newPeriodicFlushTimeIntervalMs = params.getWriteBufferPeriodicFlushTimerTickMs() != -1L ? params.getWriteBufferPeriodicFlushTimerTickMs() : this.connectionConfig.getWriteBufferPeriodicFlushTimerTickMs();
        this.setWriteBufferPeriodicFlush(newPeriodicFlushTimeoutMs, newPeriodicFlushTimeIntervalMs);
        this.writeBufferSize = params.getWriteBufferSize() != -1L ? params.getWriteBufferSize() : this.connectionConfig.getWriteBufferSize();
        this.maxKeyValueSize = params.getMaxKeyValueSize() != -1 ? params.getMaxKeyValueSize() : this.connectionConfig.getMaxKeyValueSize();
        this.ohTable = new OHTable(this.tableName, ohConnection, this.connectionConfig, this.pool);
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void mutate(Mutation mutation) throws IOException {
        this.mutate(Collections.singletonList(mutation));
    }

    public void mutate(List<? extends Mutation> mutations) throws IOException {
        this.checkClose();
        if (mutations.isEmpty()) {
            return;
        }
        long toAddSize = 0L;
        int toAddCount = 0;
        for (Mutation mutation : mutations) {
            this.validateOperation(mutation);
            toAddSize += mutation.heapSize();
            ++toAddCount;
        }
        if (this.currentAsyncBufferSize.get() == 0L) {
            this.firstRecordInBufferTimestamp.set(System.currentTimeMillis());
        }
        this.undealtMutationCount.addAndGet(toAddCount);
        this.currentAsyncBufferSize.addAndGet(toAddSize);
        this.asyncWriteBuffer.addAll(mutations);
        this.execute(false);
    }

    private void checkClose() {
        if (this.closed) {
            throw new IllegalStateException("The BufferedMutator is closed.");
        }
    }

    private void validateOperation(Mutation mt) throws IllegalArgumentException {
        if (mt == null) {
            throw new IllegalArgumentException("Mutation operation cannot be null.");
        }
        if (!(mt instanceof Put) && !(mt instanceof Delete)) {
            throw new IllegalArgumentException("Only support for Put and Delete for now.");
        }
        if (mt instanceof Put) {
            HTable.validatePut((Put)((Put)mt), (int)this.maxKeyValueSize);
            OHTable.checkFamilyViolation(mt.getFamilyCellMap().keySet(), true);
        } else {
            OHTable.checkFamilyViolation(mt.getFamilyCellMap().keySet(), false);
        }
    }

    public void timeTriggerForWriteBufferPeriodicFlush() {
        if (this.currentAsyncBufferSize.get() == 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.firstRecordInBufferTimestamp.get() + this.writeBufferPeriodicFlushTimeoutMs.get() > now) {
            return;
        }
        try {
            this.executedWriteBufferPeriodicFlushes.incrementAndGet();
            this.flush();
        }
        catch (Exception e) {
            LOGGER.error("Errors occur during timeTriggerForWriteBufferPeriodicFlush: { " + e.getMessage() + " }");
        }
    }

    public synchronized void setWriteBufferPeriodicFlush(long timeoutMs, long timerTickMs) {
        long originalTimeoutMs = this.writeBufferPeriodicFlushTimeoutMs.get();
        long originalTimeTickMs = this.writeBufferPeriodicFlushTimerTickMs.get();
        this.writeBufferPeriodicFlushTimeoutMs.set(Math.max(0L, timeoutMs));
        this.writeBufferPeriodicFlushTimerTickMs.set(Math.max(100L, timerTickMs));
        if ((this.writeBufferPeriodicFlushTimeoutMs.get() != originalTimeoutMs || this.writeBufferPeriodicFlushTimerTickMs.get() != originalTimeTickMs) && this.writeBufferPeriodicFlushTimer != null) {
            this.writeBufferPeriodicFlushTimer.cancel();
            this.writeBufferPeriodicFlushTimer = null;
        }
        if (this.writeBufferPeriodicFlushTimer == null && this.writeBufferPeriodicFlushTimeoutMs.get() > 0L) {
            this.writeBufferPeriodicFlushTimer = new Timer(true);
            this.writeBufferPeriodicFlushTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    OHBufferedMutatorImpl.this.timeTriggerForWriteBufferPeriodicFlush();
                }
            }, this.writeBufferPeriodicFlushTimerTickMs.get(), this.writeBufferPeriodicFlushTimerTickMs.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(boolean flushAll) throws IOException {
        LinkedList<Mutation> execBuffer = new LinkedList<Mutation>();
        try {
            if (flushAll || this.currentAsyncBufferSize.get() > this.writeBufferSize) {
                Object m;
                int dealtCount = 0;
                while ((m = this.asyncWriteBuffer.poll()) != null) {
                    execBuffer.add((Mutation)m);
                    long size = m.heapSize();
                    this.currentAsyncBufferSize.addAndGet(-size);
                    ++dealtCount;
                }
                this.undealtMutationCount.addAndGet(-dealtCount);
            }
            if (execBuffer.isEmpty()) {
                return;
            }
            Object[] results = new Object[execBuffer.size()];
            this.ohTable.batch(execBuffer, results);
            execBuffer.clear();
        }
        catch (Exception ex) {
            LOGGER.error(TableClientLoggerFactory.LCD.convert("01-00026"), (Throwable)ex);
            if (ex.getCause() instanceof RetriesExhaustedWithDetailsException) {
                LOGGER.error(this.tableName + ": One or more of the operations have failed after retries.");
                RetriesExhaustedWithDetailsException retryException = (RetriesExhaustedWithDetailsException)ex.getCause();
                execBuffer.clear();
                for (int i = 0; i < retryException.getNumExceptions(); ++i) {
                    execBuffer.add((Mutation)retryException.getRow(i));
                }
                if (this.listener != null) {
                    this.listener.onException(retryException, (BufferedMutator)this);
                }
                throw retryException;
            }
            LOGGER.error("Errors unrelated to operations occur during mutation operation", (Throwable)ex);
            throw ex;
        }
        finally {
            for (Mutation mutation : execBuffer) {
                long size = mutation.heapSize();
                this.currentAsyncBufferSize.addAndGet(size);
                this.asyncWriteBuffer.add(mutation);
                this.undealtMutationCount.incrementAndGet();
            }
        }
    }

    public void disableWriteBufferPeriodicFlush() {
        this.setWriteBufferPeriodicFlush(0L, 100L);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.disableWriteBufferPeriodicFlush();
        try {
            this.execute(true);
        }
        finally {
            if (this.cleanupPoolOnClose) {
                this.pool.shutdown();
                try {
                    if (!this.pool.awaitTermination(600L, TimeUnit.SECONDS)) {
                        LOGGER.warn("close() failed to terminate pool after 10 minutes. Abandoning pool.");
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("waitForTermination interrupted");
                    Thread.currentThread().interrupt();
                }
            }
            this.closed = true;
        }
    }

    public void flush() throws IOException {
        this.checkClose();
        this.execute(true);
    }

    public long getWriteBufferPeriodicFlushTimeoutMs() {
        return this.writeBufferPeriodicFlushTimeoutMs.get();
    }

    public long getWriteBufferPeriodicFlushTimerTickMs() {
        return this.writeBufferPeriodicFlushTimerTickMs.get();
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout.set(rpcTimeout);
        this.ohTable.setRpcTimeout(rpcTimeout);
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout.set(operationTimeout);
        this.ohTable.setOperationTimeout(operationTimeout);
    }

    @VisibleForTesting
    public int size() {
        return this.undealtMutationCount.get();
    }

    @VisibleForTesting
    public ExecutorService getPool() {
        return this.pool;
    }

    @VisibleForTesting
    protected long getExecutedWriteBufferPeriodicFlushes() {
        return this.executedWriteBufferPeriodicFlushes.get();
    }
}

