/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

public enum ObReplicaType {
    REPLICA_TYPE_FULL("FULL", 0),
    REPLICA_TYPE_LOGONLY("LOGONLY", 5),
    REPLICA_TYPE_READONLY("READONLY", 16),
    REPLICA_TYPE_INVALID("INVALID", Integer.MAX_VALUE);

    private String name;
    private int index;

    private ObReplicaType(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static ObReplicaType getReplicaType(int idx) {
        if (ObReplicaType.REPLICA_TYPE_FULL.index == idx) {
            return REPLICA_TYPE_FULL;
        }
        if (ObReplicaType.REPLICA_TYPE_LOGONLY.index == idx) {
            return REPLICA_TYPE_LOGONLY;
        }
        if (ObReplicaType.REPLICA_TYPE_READONLY.index == idx) {
            return REPLICA_TYPE_READONLY;
        }
        return REPLICA_TYPE_INVALID;
    }

    public boolean isReadable() {
        return this.index == ObReplicaType.REPLICA_TYPE_FULL.index || this.index == ObReplicaType.REPLICA_TYPE_READONLY.index;
    }

    public boolean isReadonly() {
        return this.index == ObReplicaType.REPLICA_TYPE_READONLY.index;
    }

    public String toString() {
        return this.name;
    }
}

