/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

public class ObPartIdCalculator {
    public static final Long OB_TWOPART_BEGIN_MASK = 0x1000000010000000L;

    public static long getPartIdx(long partId, int subPartNum) {
        return ObPartIdCalculator.extractPartIdx(partId) * (long)subPartNum + ObPartIdCalculator.extractSubpartIdx(partId);
    }

    public static Long generatePartId(Long partId1, Long partId2) {
        if (null == partId1) {
            return null;
        }
        if (null == partId2) {
            return partId1;
        }
        return partId1 << 32 | partId2 | OB_TWOPART_BEGIN_MASK;
    }

    public static long extractSubpartId(long id) {
        return id & 0xFFFFFFFFL;
    }

    public static long extractPartId(long id) {
        return id >> 32;
    }

    public static long extractIdxFromPartId(long id) {
        return id & 0xFFFFFFFL;
    }

    public static long extractSpaceFromPartId(long id) {
        return id >> 28;
    }

    public static long extractPartIdx(long id) {
        return ObPartIdCalculator.extractIdxFromPartId(ObPartIdCalculator.extractPartId(id));
    }

    public static long extractSubpartIdx(long id) {
        return ObPartIdCalculator.extractIdxFromPartId(ObPartIdCalculator.extractSubpartId(id));
    }
}

