/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load;

import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObLoadDupActionType;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableDirectLoadBeginArg
implements ObSimplePayload {
    private String tableName;
    private long parallel = 0L;
    private long maxErrorRowCount = 0L;
    private ObLoadDupActionType dupAction = ObLoadDupActionType.INVALID_MODE;
    private long timeout = 0L;
    private long heartBeatTimeout = 0L;
    private boolean forceCreate = false;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public long getParallel() {
        return this.parallel;
    }

    public void setParallel(long parallel) {
        this.parallel = parallel;
    }

    public long getMaxErrorRowCount() {
        return this.maxErrorRowCount;
    }

    public void setMaxErrorRowCount(long maxErrorRowCount) {
        this.maxErrorRowCount = maxErrorRowCount;
    }

    public ObLoadDupActionType getDupAction() {
        return this.dupAction;
    }

    public void setDupAction(ObLoadDupActionType dupAction) {
        this.dupAction = dupAction;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatTimeout(long heartBeatTimeout) {
        this.heartBeatTimeout = heartBeatTimeout;
    }

    public boolean getForceCreate() {
        return this.forceCreate;
    }

    public void setForceCreate(boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    @Override
    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeVString(buf, this.tableName);
        Serialization.encodeVi64(buf, this.parallel);
        Serialization.encodeVi64(buf, this.maxErrorRowCount);
        Serialization.encodeI8(buf, this.dupAction.getByteValue());
        Serialization.encodeVi64(buf, this.timeout);
        Serialization.encodeVi64(buf, this.heartBeatTimeout);
        Serialization.encodeI8(buf, (byte)(this.forceCreate ? 1 : 0));
    }

    @Override
    public ObTableDirectLoadBeginArg decode(ByteBuf buf) {
        this.tableName = Serialization.decodeVString(buf);
        this.parallel = Serialization.decodeVi64(buf);
        this.maxErrorRowCount = Serialization.decodeVi64(buf);
        this.dupAction = ObLoadDupActionType.valueOf(Serialization.decodeI8(buf));
        this.timeout = Serialization.decodeVi64(buf);
        this.heartBeatTimeout = Serialization.decodeVi64(buf);
        this.forceCreate = Serialization.decodeI8(buf) != 0;
        return this;
    }

    @Override
    public int getEncodedSize() {
        int len = 0;
        len += Serialization.getNeedBytes(this.tableName);
        len += Serialization.getNeedBytes(this.parallel);
        len += Serialization.getNeedBytes(this.maxErrorRowCount);
        ++len;
        len += Serialization.getNeedBytes(this.timeout);
        len += Serialization.getNeedBytes(this.heartBeatTimeout);
        return ++len;
    }
}

