/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOpResult;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ObTableLSOpResult
extends AbstractPayload {
    private List<ObTableTabletOpResult> results = new ArrayList<ObTableTabletOpResult>();
    private List<String> propertiesColumnNames = new ArrayList<String>();

    @Override
    public int getPcode() {
        return 4389;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        int len = Serialization.getNeedBytes(this.propertiesColumnNames.size());
        System.arraycopy(Serialization.encodeVi64(this.propertiesColumnNames.size()), 0, bytes, idx, len);
        for (String columnName : this.propertiesColumnNames) {
            len = Serialization.getNeedBytes(columnName);
            System.arraycopy(Serialization.encodeVString(columnName), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.results.size());
        System.arraycopy(Serialization.encodeVi64(this.results.size()), 0, bytes, idx, len);
        idx += len;
        for (ObTableTabletOpResult result : this.results) {
            len = (int)result.getPayloadSize();
            System.arraycopy(result.encode(), 0, bytes, idx, len);
            idx += len;
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        int i;
        super.decode(buf);
        int len = (int)Serialization.decodeVi64(buf);
        for (i = 0; i < len; ++i) {
            String column = Serialization.decodeVString(buf);
            this.propertiesColumnNames.add(column);
        }
        len = (int)Serialization.decodeVi64(buf);
        this.results = new ArrayList<ObTableTabletOpResult>(len);
        for (i = 0; i < len; ++i) {
            ObTableTabletOpResult tabletOpResult = new ObTableTabletOpResult();
            tabletOpResult.setPropertiesColumnNames(this.propertiesColumnNames);
            tabletOpResult.decode(buf);
            this.results.add(tabletOpResult);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        payloadContentSize += (long)Serialization.getNeedBytes(this.results.size());
        for (ObTableTabletOpResult result : this.results) {
            payloadContentSize += result.getPayloadSize();
        }
        return payloadContentSize;
    }

    public List<ObTableTabletOpResult> getResults() {
        return this.results;
    }

    public void setResults(List<ObTableTabletOpResult> results) {
        this.results = results;
    }

    public void addResult(ObTableTabletOpResult result) {
        this.results.add(result);
    }

    public void addAllResults(List<ObTableTabletOpResult> results) {
        this.results.addAll(results);
    }
}

