/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.login;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

public class ObTableLoginRequest
extends AbstractPayload {
    private byte authMethod = 1;
    private byte clientType = (byte)2;
    private byte clientVersion = 1;
    private byte reversed1;
    private int clientCapabilities;
    private int maxPacketSize;
    private int reversed2 = 0;
    private long reversed3 = 0L;
    private String tenantName;
    private String userName;
    private ObBytesString passSecret;
    private ObBytesString passScramble;
    private String databaseName;
    private long ttlUs;

    @Override
    public int getPcode() {
        return 4353;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        idx += headerLen;
        bytes[idx++] = this.authMethod;
        bytes[idx++] = this.clientType;
        bytes[idx++] = this.clientVersion;
        bytes[idx++] = this.reversed1;
        int len = Serialization.getNeedBytes(this.clientCapabilities);
        System.arraycopy(Serialization.encodeVi32(this.clientCapabilities), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.maxPacketSize);
        System.arraycopy(Serialization.encodeVi32(this.maxPacketSize), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.reversed2);
        System.arraycopy(Serialization.encodeVi32(this.reversed2), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.reversed3);
        System.arraycopy(Serialization.encodeVi64(this.reversed3), 0, bytes, idx, len);
        byte[] strbytes = Serialization.encodeVString(this.tenantName);
        System.arraycopy(strbytes, 0, bytes, idx += len, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeVString(this.userName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeBytesString(this.passSecret);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeBytesString(this.passScramble);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        idx += strbytes.length;
        strbytes = Serialization.encodeVString(this.databaseName);
        System.arraycopy(strbytes, 0, bytes, idx, strbytes.length);
        len = Serialization.getNeedBytes(this.ttlUs);
        System.arraycopy(Serialization.encodeVi64(this.ttlUs), 0, bytes, idx += strbytes.length, len);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(byte[] bytes) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        try {
            buf.writeBytes(bytes);
            Object object = this.decode(buf);
            return object;
        }
        finally {
            buf.release();
        }
    }

    @Override
    public Object decode(ByteBuf buf) {
        this.authMethod = buf.readByte();
        this.clientType = buf.readByte();
        this.clientVersion = buf.readByte();
        buf.readByte();
        this.clientCapabilities = Serialization.decodeVi32(buf);
        this.maxPacketSize = Serialization.decodeVi32(buf);
        Serialization.decodeVi32(buf);
        Serialization.decodeVi64(buf);
        this.tenantName = Serialization.decodeVString(buf);
        this.userName = Serialization.decodeVString(buf);
        this.passSecret = Serialization.decodeBytesString(buf);
        this.passScramble = Serialization.decodeBytesString(buf);
        this.databaseName = Serialization.decodeVString(buf);
        this.ttlUs = Serialization.decodeVi64(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return 4 + Serialization.getNeedBytes(this.clientCapabilities) + Serialization.getNeedBytes(this.maxPacketSize) + Serialization.getNeedBytes(this.reversed2) + Serialization.getNeedBytes(this.reversed3) + Serialization.getNeedBytes(this.tenantName) + Serialization.getNeedBytes(this.userName) + Serialization.getNeedBytes(this.passSecret) + Serialization.getNeedBytes(this.passScramble) + Serialization.getNeedBytes(this.databaseName) + Serialization.getNeedBytes(this.ttlUs);
    }

    public byte getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(byte authMethod) {
        this.authMethod = authMethod;
    }

    public byte getClientType() {
        return this.clientType;
    }

    public void setClientType(byte clientType) {
        this.clientType = clientType;
    }

    public byte getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(byte clientVersion) {
        this.clientVersion = clientVersion;
    }

    public byte getReversed1() {
        return this.reversed1;
    }

    public void setReversed1(byte reversed1) {
        this.reversed1 = reversed1;
    }

    public int getClientCapabilities() {
        return this.clientCapabilities;
    }

    public void setClientCapabilities(int clientCapabilities) {
        this.clientCapabilities = clientCapabilities;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getReversed2() {
        return this.reversed2;
    }

    public void setReversed2(int reversed2) {
        this.reversed2 = reversed2;
    }

    public long getReversed3() {
        return this.reversed3;
    }

    public void setReversed3(long reversed3) {
        this.reversed3 = reversed3;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ObBytesString getPassSecret() {
        return this.passSecret;
    }

    public void setPassSecret(ObBytesString passSecret) {
        this.passSecret = passSecret;
    }

    public void setPassSecret(String passSecret) {
        this.passSecret = new ObBytesString(passSecret);
    }

    public ObBytesString getPassScramble() {
        return this.passScramble;
    }

    public void setPassScramble(ObBytesString passScramble) {
        this.passScramble = passScramble;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public long getTtlUs() {
        return this.ttlUs;
    }

    public void setTtlUs(long ttlUs) {
        this.ttlUs = ttlUs;
    }
}

