/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObHTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObScanOrder;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.table.AbstractTableQuery;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTableQueryImpl
extends AbstractTableQuery {
    protected ObTableQuery tableQuery;
    protected String indexTableName;

    @Override
    public TableQuery select(String ... columns) {
        this.tableQuery.setSelectColumns(Arrays.asList(columns));
        return this;
    }

    @Override
    public List<String> getSelectColumns() {
        return this.tableQuery.getSelectColumns();
    }

    @Override
    public TableQuery limit(int limit) {
        this.tableQuery.setLimit(limit);
        return this;
    }

    @Override
    public TableQuery limit(int offset, int limit) {
        this.tableQuery.setLimit(limit);
        this.tableQuery.setOffset(offset);
        return this;
    }

    @Override
    public TableQuery addScanRange(Object[] start, boolean startEquals, Object[] end, boolean endEquals) {
        ObNewRange obNewRange = new ObNewRange();
        obNewRange.setStartKey(ObRowKey.getInstance(start));
        obNewRange.setEndKey(ObRowKey.getInstance(end));
        if (startEquals) {
            obNewRange.getBorderFlag().setInclusiveStart();
        } else {
            obNewRange.getBorderFlag().unsetInclusiveStart();
        }
        if (endEquals) {
            obNewRange.getBorderFlag().setInclusiveEnd();
        } else {
            obNewRange.getBorderFlag().unsetInclusiveEnd();
        }
        this.tableQuery.addKeyRange(obNewRange);
        return this;
    }

    @Override
    public TableQuery addScanRangeStartsWith(Object[] start, boolean startEquals) {
        ObNewRange obNewRange = new ObNewRange();
        obNewRange.setStartKey(ObRowKey.getInstance(start));
        obNewRange.setEndKey(ObRowKey.getInstance(ObObj.getMax()));
        if (startEquals) {
            obNewRange.getBorderFlag().setInclusiveStart();
        } else {
            obNewRange.getBorderFlag().unsetInclusiveStart();
        }
        this.tableQuery.addKeyRange(obNewRange);
        return this;
    }

    @Override
    public TableQuery addScanRangeEndsWith(Object[] end, boolean endEquals) {
        ObNewRange obNewRange = new ObNewRange();
        obNewRange.setStartKey(ObRowKey.getInstance(ObObj.getMin()));
        obNewRange.setEndKey(ObRowKey.getInstance(end));
        if (endEquals) {
            obNewRange.getBorderFlag().setInclusiveEnd();
        } else {
            obNewRange.getBorderFlag().unsetInclusiveEnd();
        }
        this.tableQuery.addKeyRange(obNewRange);
        return this;
    }

    @Override
    public TableQuery scanOrder(boolean forward) {
        this.tableQuery.setScanOrder(forward ? ObScanOrder.Forward : ObScanOrder.Reverse);
        return this;
    }

    @Override
    public TableQuery indexName(String indexName) {
        this.tableQuery.setIndexName(indexName);
        return this;
    }

    @Override
    public TableQuery filterString(String filterString) {
        this.tableQuery.setFilterString(filterString);
        return this;
    }

    @Override
    public TableQuery setHTableFilter(ObHTableFilter obHTableFilter) {
        this.tableQuery.sethTableFilter(obHTableFilter);
        return this;
    }

    @Override
    public TableQuery setBatchSize(int batchSize) {
        this.tableQuery.setBatchSize(batchSize);
        return this;
    }

    @Override
    public TableQuery setMaxResultSize(long maxResultSize) {
        this.tableQuery.setMaxResultSize(maxResultSize);
        return this;
    }

    public String getIndexTableName() {
        return this.indexTableName;
    }

    public void setIndexTableName(String indexTableName) {
        this.indexTableName = indexTableName;
    }
}

