/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc;

public class ObGlobal {
    static long OB_VSN_MAJOR_SHIFT = 32L;
    static long OB_VSN_MINOR_SHIFT = 16L;
    static long OB_VSN_MAJOR_PATCH_SHIFT = 8L;
    static long OB_VSN_MINOR_PATCH_SHIFT = 0L;
    static int OB_VSN_MAJOR_MASK = -1;
    static short OB_VSN_MINOR_MASK = (short)-1;
    static byte OB_VSN_MAJOR_PATCH_MASK = (byte)-1;
    static byte OB_VSN_MINOR_PATCH_MASK = (byte)-1;
    public static final long OB_VERSION_4_2_1_0 = ObGlobal.calcVersion(4, (short)2, (byte)1, (byte)0);
    public static final long OB_VERSION_4_2_3_0 = ObGlobal.calcVersion(4, (short)2, (byte)3, (byte)0);
    public static final long OB_VERSION_4_3_0_0 = ObGlobal.calcVersion(4, (short)3, (byte)0, (byte)0);
    public static long OB_VERSION = ObGlobal.calcVersion(0, (short)0, (byte)0, (byte)0);

    public static long calcVersion(int major, short minor, byte major_patch, byte minor_patch) {
        return ((long)major << (int)OB_VSN_MAJOR_SHIFT) + ((long)minor << (int)OB_VSN_MINOR_SHIFT) + ((long)major_patch << (int)OB_VSN_MAJOR_PATCH_SHIFT) + ((long)minor_patch << (int)OB_VSN_MINOR_PATCH_SHIFT);
    }

    public static long calcVersion(long major, long minor, long major_patch, long minor_patch) {
        return (major << (int)OB_VSN_MAJOR_SHIFT) + (minor << (int)OB_VSN_MINOR_SHIFT) + (major_patch << (int)OB_VSN_MAJOR_PATCH_SHIFT) + (minor_patch << (int)OB_VSN_MINOR_PATCH_SHIFT);
    }

    public static int obVsnMajor() {
        return ObGlobal.getObVsnMajor(OB_VERSION);
    }

    public static int getObVsnMajor(long version) {
        return (int)(version >> (int)OB_VSN_MAJOR_SHIFT & (long)OB_VSN_MAJOR_MASK);
    }

    public static short obVsnMinor() {
        return ObGlobal.getObVsnMinor(OB_VERSION);
    }

    public static short getObVsnMinor(long version) {
        return (short)(version >> (int)OB_VSN_MINOR_SHIFT & (long)OB_VSN_MINOR_MASK);
    }

    public static byte obVsnMajorPatch() {
        return ObGlobal.getObVsnMajorPatch(OB_VERSION);
    }

    public static byte getObVsnMajorPatch(long version) {
        return (byte)(version >> (int)OB_VSN_MAJOR_PATCH_SHIFT & (long)OB_VSN_MAJOR_PATCH_MASK);
    }

    public static byte obVsnMinorPatch() {
        return ObGlobal.getObVsnMinorPatch(OB_VERSION);
    }

    public static byte getObVsnMinorPatch(long version) {
        return (byte)(version >> (int)OB_VSN_MINOR_PATCH_SHIFT & (long)OB_VSN_MINOR_PATCH_MASK);
    }

    public static String obVsnString() {
        return String.format("%d.%d.%d.%d", ObGlobal.obVsnMajor(), ObGlobal.obVsnMinor(), ObGlobal.obVsnMajorPatch(), ObGlobal.obVsnMinorPatch());
    }

    public static String getObVsnString(long version) {
        return String.format("%d.%d.%d.%d", ObGlobal.getObVsnMajor(version), ObGlobal.getObVsnMinor(version), ObGlobal.getObVsnMajorPatch(version), ObGlobal.getObVsnMinorPatch(version));
    }

    public static boolean isLsOpSupport() {
        return OB_VERSION >= OB_VERSION_4_2_3_0 && OB_VERSION < OB_VERSION_4_3_0_0;
    }
}

