/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.transport;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacketCode;
import com.alipay.oceanbase.rpc.bolt.transport.ObClientFuture;
import com.alipay.oceanbase.rpc.bolt.transport.ObTableConnection;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableRoutingWrongException;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.protocol.packet.ObCompressType;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.Credentialable;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObRpcResultCode;
import com.alipay.oceanbase.rpc.protocol.payload.impl.login.ObTableLoginRequest;
import com.alipay.oceanbase.rpc.util.ObPureCrc32C;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import com.alipay.oceanbase.rpc.util.TraceUtil;
import com.alipay.remoting.BaseRemoting;
import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.exception.RemotingException;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;

public class ObTableRemoting
extends BaseRemoting {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableRemoting.class);

    public ObTableRemoting(CommandFactory commandFactory) {
        super(commandFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObPayload invokeSync(ObTableConnection conn, ObPayload request, int timeoutMillis) throws RemotingException, InterruptedException {
        request.setSequence(conn.getNextSequence());
        request.setUniqueId(conn.getUniqueId());
        if (request instanceof Credentialable) {
            if (conn.getCredential() == null) {
                String errMessage = TraceUtil.formatTraceMessage(conn, request, "credential is null");
                logger.warn(errMessage);
                throw new ObTableUnexpectedException(errMessage);
            }
            ((Credentialable)((Object)request)).setCredential(conn.getCredential());
        }
        if (request instanceof ObTableLoginRequest) {
            ((ObTableLoginRequest)request).setTenantId(1L);
        } else if (request instanceof AbstractPayload) {
            ((AbstractPayload)request).setTenantId(conn.getTenantId());
        }
        ObTablePacket obRequest = (ObTablePacket)this.getCommandFactory().createRequestCommand((Object)request);
        ObTablePacket response = (ObTablePacket)super.invokeSync(conn.getConnection(), (RemotingCommand)obRequest, timeoutMillis);
        if (response == null) {
            String errMessage = TraceUtil.formatTraceMessage(conn, request, "get null response");
            logger.warn(errMessage);
            ExceptionUtil.throwObTableTransportException(errMessage, -20001);
            return null;
        }
        if (!response.isSuccess()) {
            String errMessage = TraceUtil.formatTraceMessage(conn, request, "get an error response: " + response.getMessage());
            logger.warn(errMessage);
            response.releaseByteBuf();
            ExceptionUtil.throwObTableTransportException(errMessage, response.getTransportCode());
            return null;
        }
        try {
            response.decodePacketHeader();
            ObCompressType compressType = response.getHeader().getObCompressType();
            if (compressType != ObCompressType.INVALID_COMPRESSOR && compressType != ObCompressType.NONE_COMPRESSOR) {
                String errMessage = TraceUtil.formatTraceMessage(conn, request, "Rpc Result is compressed. Java Client is not supported. msg:" + response.getMessage());
                logger.warn(errMessage);
                throw new FeatureNotSupportedException(errMessage);
            }
            ByteBuf buf = response.getPacketContentBuf();
            if (response.getHeader().isRoutingWrong()) {
                String errMessage = TraceUtil.formatTraceMessage(conn, request, "routed to the wrong server: " + response.getMessage());
                logger.warn(errMessage);
                throw new ObTableRoutingWrongException(errMessage);
            }
            long expected_checksum = response.getHeader().getChecksum();
            byte[] content = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), content);
            if (ObPureCrc32C.calculate(content) != expected_checksum) {
                String errMessage = TraceUtil.formatTraceMessage(conn, request, "get response with checksum error: " + response.getMessage());
                logger.warn(errMessage);
                ExceptionUtil.throwObTableTransportException(errMessage, -20004);
                ObPayload obPayload = null;
                return obPayload;
            }
            ObRpcResultCode resultCode = new ObRpcResultCode();
            resultCode.decode(buf);
            if (resultCode.getRcode() != 0) {
                ExceptionUtil.throwObTableException(conn.getObTable().getIp(), conn.getObTable().getPort(), response.getHeader().getTraceId1(), response.getHeader().getTraceId0(), resultCode.getRcode(), resultCode.getErrMsg());
                ObPayload obPayload = null;
                return obPayload;
            }
            if (!(response.getCmdCode() instanceof ObTablePacketCode)) {
                String errMessage = TraceUtil.formatTraceMessage(conn, response, "receive unexpected command code: " + response.getCmdCode().value());
                throw new ObTableUnexpectedException(errMessage);
            }
            ObPayload payload = ((ObTablePacketCode)response.getCmdCode()).newPayload(response.getHeader());
            payload.setSequence(response.getHeader().getTraceId1());
            payload.setUniqueId(response.getHeader().getTraceId0());
            payload.decode(buf);
            ObPayload obPayload = payload;
            return obPayload;
        }
        finally {
            response.releaseByteBuf();
        }
    }

    protected InvokeFuture createInvokeFuture(RemotingCommand request, InvokeContext invokeContext) {
        return new ObClientFuture(request.getId());
    }

    protected InvokeFuture createInvokeFuture(Connection conn, RemotingCommand request, InvokeContext invokeContext, InvokeCallback invokeCallback) {
        return new ObClientFuture(request.getId());
    }
}

