/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.mutation.ColumnValue;
import com.alipay.oceanbase.rpc.mutation.Delete;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.table.api.Table;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Mutation<T> {
    private String tableName;
    private Table client;
    protected Object[] rowKey;
    private TableQuery query;
    private boolean hasSetRowKey = false;
    protected List<String> rowKeyNames = null;
    protected List<String> columns;
    protected List<Object> values;

    public Mutation() {
        this.tableName = null;
        this.client = null;
        this.rowKey = null;
        this.query = null;
        this.rowKeyNames = null;
        this.columns = null;
        this.values = null;
    }

    public Mutation(Table client, String tableName) {
        if (null == client || null == tableName || tableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid input to create Mutation in table" + tableName);
        }
        this.client = client;
        this.tableName = tableName;
        this.rowKey = null;
        this.query = null;
        this.rowKeyNames = null;
        this.columns = null;
        this.values = null;
    }

    protected Table getClient() {
        return this.client;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected TableQuery getQuery() {
        return this.query;
    }

    public Object[] getRowKey() {
        return this.rowKey;
    }

    protected List<ObNewRange> getKeyRanges() {
        if (null != this.query) {
            return this.query.getObTableQuery().getKeyRanges();
        }
        return null;
    }

    public ObTableOperationType getOperationType() {
        return null;
    }

    public List<String> getRowKeyNames() {
        return this.rowKeyNames;
    }

    protected boolean checkMutationWithFilter() {
        if (null == this.query) {
            return false;
        }
        return this.query.getObTableQuery().isFilterNull();
    }

    public T setClient(ObTableClient client) {
        if (null == client) {
            throw new IllegalArgumentException("Invalid client to create Mutation");
        }
        this.client = client;
        return (T)this;
    }

    public T setTable(String tableName) {
        if (null == tableName || tableName.isEmpty()) {
            throw new IllegalArgumentException("Invalid table name to create Mutation in table" + tableName);
        }
        this.tableName = tableName;
        return (T)this;
    }

    public T setRowKey(Row rowKey) {
        if (this.hasSetRowKey) {
            throw new IllegalArgumentException("Could not set row key (scan range) twice");
        }
        if (null == rowKey) {
            throw new IllegalArgumentException("Invalid null rowKey set into Mutation");
        }
        if (0 == rowKey.getMap().size()) {
            throw new IllegalArgumentException("input row key should not be empty");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> Keys = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : rowKey.getMap().entrySet()) {
            columnNames.add(entry.getKey());
            Keys.add(entry.getValue());
        }
        this.rowKey = Keys.toArray();
        this.rowKeyNames = columnNames;
        if (null != this.tableName) {
            ((ObTableClient)this.client).addRowKeyElement(this.tableName, columnNames.toArray(new String[0]));
        }
        if (null != this.query) {
            this.query.addScanRange(this.rowKey, this.rowKey);
        }
        this.hasSetRowKey = true;
        return (T)this;
    }

    protected T setRowKeyOnly(Row rowKey) {
        if (this.hasSetRowKey) {
            throw new IllegalArgumentException("Could not set row key (scan range) twice");
        }
        if (null == rowKey) {
            throw new IllegalArgumentException("Invalid null rowKey set into Mutation");
        }
        if (0 == rowKey.getMap().size()) {
            throw new IllegalArgumentException("input row key should not be empty");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> Keys = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : rowKey.getMap().entrySet()) {
            columnNames.add(entry.getKey());
            Keys.add(entry.getValue());
        }
        this.rowKey = Keys.toArray();
        this.rowKeyNames = columnNames;
        if (null != this.tableName) {
            ((ObTableClient)this.client).addRowKeyElement(this.tableName, columnNames.toArray(new String[0]));
        }
        this.hasSetRowKey = true;
        return (T)this;
    }

    public T setRowKey(ColumnValue ... rowKey) {
        if (this.hasSetRowKey) {
            throw new IllegalArgumentException("Could not set row key (scan range) twice");
        }
        if (null == rowKey) {
            throw new IllegalArgumentException("Invalid null rowKey set into Mutation");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> Keys = new ArrayList<Object>();
        for (ColumnValue columnValue : rowKey) {
            if (columnNames.contains(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in Row Key");
            }
            columnNames.add(columnValue.getColumnName());
            Keys.add(columnValue.getValue());
        }
        this.rowKey = Keys.toArray();
        this.rowKeyNames = columnNames;
        if (null != this.tableName) {
            ((ObTableClient)this.client).addRowKeyElement(this.tableName, columnNames.toArray(new String[0]));
        }
        if (null != this.query) {
            this.query.addScanRange(this.rowKey, this.rowKey);
        }
        this.hasSetRowKey = true;
        return (T)this;
    }

    public T setRowKeyOnly(ColumnValue ... rowKey) {
        if (this.hasSetRowKey) {
            throw new IllegalArgumentException("Could not set row key (scan range) twice");
        }
        if (null == rowKey) {
            throw new IllegalArgumentException("Invalid null rowKey set into Mutation");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> Keys = new ArrayList<Object>();
        for (ColumnValue columnValue : rowKey) {
            if (columnNames.contains(columnValue.getColumnName())) {
                throw new ObTableException("Duplicate column in Row Key");
            }
            columnNames.add(columnValue.getColumnName());
            Keys.add(columnValue.getValue());
        }
        this.rowKey = Keys.toArray();
        this.rowKeyNames = columnNames;
        if (null != this.tableName) {
            ((ObTableClient)this.client).addRowKeyElement(this.tableName, columnNames.toArray(new String[0]));
        }
        this.hasSetRowKey = true;
        return (T)this;
    }

    public T setFilter(ObTableFilter filter) throws Exception {
        if (null == filter) {
            throw new IllegalArgumentException("Invalid null filter set into Mutation");
        }
        if (null != this.client) {
            if (null == this.query) {
                this.query = this.client.query(this.tableName);
                if (null != this.rowKey) {
                    this.query.addScanRange(this.rowKey, this.rowKey);
                }
            }
            this.query.setFilter(filter);
        }
        return (T)this;
    }

    public T setFilterOnly(ObTableFilter filter) throws Exception {
        if (null == filter) {
            throw new IllegalArgumentException("Invalid null filter set into Mutation");
        }
        if (null != this.client) {
            if (null == this.query) {
                this.query = this.client.query(this.tableName);
            }
            this.query.setFilter(filter);
        }
        return (T)this;
    }

    public T setScanRangeColumns(String ... columnNames) throws Exception {
        if (null == columnNames) {
            throw new IllegalArgumentException("Invalid null column names set into Mutation");
        }
        if (null == this.query) {
            this.query = this.client.query(this.tableName);
        }
        this.query.setScanRangeColumns(columnNames);
        if (null != this.tableName && null != this.client) {
            if (!((ObTableClient)this.client).isOdpMode()) {
                ((ObTableClient)this.client).addRowKeyElement(this.tableName, columnNames);
            }
        } else {
            throw new ObTableException("invalid table name: " + this.tableName + ", or invalid client: " + this.client + " while setting scan range columns");
        }
        return (T)this;
    }

    public T addScanRange(Object start, Object end) throws Exception {
        if (null == start || null == end) {
            throw new IllegalArgumentException("Invalid null range set into Mutation");
        }
        return this.addScanRange(new Object[]{start}, true, new Object[]{end}, true);
    }

    public T addScanRange(Object[] start, Object[] end) throws Exception {
        if (null == start || null == end) {
            throw new IllegalArgumentException("Invalid null range set into Mutation");
        }
        return this.addScanRange(start, true, end, true);
    }

    public T addScanRange(Object start, boolean startEquals, Object end, boolean endEquals) throws Exception {
        if (null == start || null == end) {
            throw new IllegalArgumentException("Invalid null range set into Mutation");
        }
        return this.addScanRange(new Object[]{start}, startEquals, new Object[]{end}, endEquals);
    }

    public T addScanRange(Object[] start, boolean startEquals, Object[] end, boolean endEquals) throws Exception {
        if (null == start || null == end) {
            throw new IllegalArgumentException("Invalid null range set into Mutation");
        }
        if (null == this.query) {
            this.query = this.client.query(this.tableName);
        }
        this.query.addScanRange(start, startEquals, end, endEquals);
        return (T)this;
    }

    static void removeRowkeyFromMutateColval(List<String> columns, List<Object> values, List<String> rowKeyNames) {
        if (null == columns || null == rowKeyNames || columns.size() != values.size()) {
            return;
        }
        for (int i = values.size() - 1; i >= 0; --i) {
            if (!rowKeyNames.contains(columns.get(i))) continue;
            columns.remove(i);
            values.remove(i);
        }
    }

    public void addColVal(String propName, ObObj propValue) {
        this.columns.add(propName);
        this.values.add(propValue);
    }

    public static Mutation getInstance(ObTableOperationType type, String[] rowKeyNames, Object[] rowKeys, String[] columns, Object[] properties) {
        int i;
        Mutation mutation = null;
        switch (type) {
            case INSERT_OR_UPDATE: {
                mutation = new InsertOrUpdate();
                break;
            }
            case DEL: {
                mutation = new Delete();
                break;
            }
            default: {
                throw new ObTableException("not support operation type " + (Object)((Object)type));
            }
        }
        Row rowKeyRow = new Row();
        if (rowKeys != null) {
            for (i = 0; i < rowKeys.length; ++i) {
                Object rowkey = rowKeys[i];
                ObObj obj = ObObj.getInstance(rowkey);
                rowKeyRow.add(rowKeyNames[i], obj);
            }
        }
        mutation.setRowKey(rowKeyRow);
        if (columns != null) {
            for (i = 0; i < columns.length; ++i) {
                String name = columns[i];
                Object value = null;
                if (properties != null) {
                    value = properties[i];
                }
                ObObj c = ObObj.getInstance(value);
                mutation.addColVal(name, c);
            }
        }
        return mutation;
    }
}

