/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public class ObAddr
implements ObSimplePayload {
    private static final long UNIS_VERSION = 1L;
    private VER version = VER.IPV4;
    private int[] ip = new int[4];
    private int port = 0;

    public VER getVersion() {
        return this.version;
    }

    public String getIPString() {
        String ipStr = new String();
        if (this.version == VER.IPV4) {
            ipStr = String.format("%d.%d.%d.%d", this.ip[0] >> 24 & 0xFF, this.ip[0] >> 16 & 0xFF, this.ip[0] >> 8 & 0xFF, this.ip[0] & 0xFF);
        }
        return ipStr;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        String str = new String();
        if (this.version == VER.IPV4) {
            str = String.format("%s:%d", this.getIPString(), this.port);
        }
        return str;
    }

    @Override
    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        long payloadContentSize = this.getPayloadContentSize();
        Serialization.encodeObUniVersionHeader(buf, 1L, payloadContentSize);
        Serialization.encodeI8(buf, this.version.getByteValue());
        for (int i = 0; i < this.ip.length; ++i) {
            Serialization.encodeVi32(buf, this.ip[i]);
        }
        Serialization.encodeVi32(buf, this.port);
    }

    @Override
    public Object decode(ByteBuf buf) {
        long unis_version = Serialization.decodeVi64(buf);
        if (unis_version != 1L) {
            throw new ObTableException("object version mismatch, version:" + unis_version);
        }
        Serialization.decodeVi64(buf);
        this.version = VER.valueOf(Serialization.decodeI8(buf));
        for (int i = 0; i < this.ip.length; ++i) {
            this.ip[i] = Serialization.decodeVi32(buf);
        }
        this.port = Serialization.decodeVi32(buf);
        return this;
    }

    public long getPayloadContentSize() {
        long payloadContentSize = 0L;
        ++payloadContentSize;
        for (int i = 0; i < this.ip.length; ++i) {
            payloadContentSize += (long)Serialization.getNeedBytes(this.ip[i]);
        }
        return payloadContentSize += (long)Serialization.getNeedBytes(this.port);
    }

    @Override
    public int getEncodedSize() {
        long payloadContentSize = this.getPayloadContentSize();
        return (int)(Serialization.getObUniVersionHeaderLength(1L, payloadContentSize) + payloadContentSize);
    }

    public static enum VER {
        IPV4(4),
        IPV6(6),
        UNIX(1);

        private final int value;
        private static final Map<Integer, VER> map;

        public static VER valueOf(int value) {
            return map.get(value);
        }

        private VER(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public byte getByteValue() {
            return (byte)this.value;
        }

        static {
            map = new HashMap<Integer, VER>();
            for (VER v : VER.values()) {
                map.put(v.value, v);
            }
        }
    }
}

