/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.Credentialable;
import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObAddr;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadOperationType;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import com.alipay.oceanbase.rpc.util.TraceUtil;
import io.netty.buffer.ByteBuf;

public class ObTableDirectLoadRequest
extends AbstractPayload
implements Credentialable {
    private Header header = new Header();
    private ObBytesString credential;
    private ObBytesString argContent = new ObBytesString();

    public ObTableDirectLoadRequest() {
        this.setVersion(2L);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public ObBytesString getCredential() {
        return this.credential;
    }

    @Override
    public void setCredential(ObBytesString credential) {
        this.credential = credential;
    }

    public ObBytesString getArgContent() {
        return this.argContent;
    }

    public void setArgContent(ObBytesString argContent) {
        if (argContent == null) {
            throw new NullPointerException();
        }
        this.argContent = argContent;
    }

    public String toString() {
        return String.format("%s {header:%s, argContent:%d}", TraceUtil.formatTraceMessage(this), this.header, this.argContent.length());
    }

    @Override
    public int getPcode() {
        return 4387;
    }

    @Override
    public byte[] encode() {
        long payloadContentSize = this.getPayloadContentSize();
        int needBytes = (int)(Serialization.getObUniVersionHeaderLength(this.getVersion(), payloadContentSize) + payloadContentSize);
        ObByteBuf buf = new ObByteBuf(needBytes);
        Serialization.encodeObUniVersionHeader(buf, this.getVersion(), payloadContentSize);
        this.header.encode(buf);
        Serialization.encodeBytesString(buf, this.credential);
        Serialization.encodeBytesString(buf, this.argContent);
        return buf.bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        this.header.decode(buf);
        this.credential = Serialization.decodeBytesString(buf);
        this.argContent = Serialization.decodeBytesString(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return this.header.getEncodedSize() + Serialization.getNeedBytes(this.credential) + Serialization.getNeedBytes(this.argContent);
    }

    public static class Header
    implements ObSimplePayload {
        private ObAddr addr = new ObAddr();
        private ObTableDirectLoadOperationType operationType = ObTableDirectLoadOperationType.MAX_TYPE;

        public ObAddr getAddr() {
            return this.addr;
        }

        public void setAddr(ObAddr addr) {
            this.addr = addr;
        }

        public ObTableDirectLoadOperationType getOperationType() {
            return this.operationType;
        }

        public void setOperationType(ObTableDirectLoadOperationType operationType) {
            this.operationType = operationType;
        }

        public String toString() {
            return String.format("{addr:%s, operationType:%s}", new Object[]{this.addr, this.operationType});
        }

        @Override
        public byte[] encode() {
            int needBytes = this.getEncodedSize();
            ObByteBuf buf = new ObByteBuf(needBytes);
            this.encode(buf);
            return buf.bytes;
        }

        @Override
        public void encode(ObByteBuf buf) {
            this.addr.encode(buf);
            Serialization.encodeI8(buf, this.operationType.getByteValue());
        }

        @Override
        public Header decode(ByteBuf buf) {
            this.addr.decode(buf);
            this.operationType = ObTableDirectLoadOperationType.valueOf(Serialization.decodeI8(buf));
            return this;
        }

        @Override
        public int getEncodedSize() {
            return this.addr.getEncodedSize() + 1;
        }
    }
}

