/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.bolt.transport.ObTableConnection;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableGlobalIndexRouteException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.location.model.ObReadConsistency;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableStreamRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.QueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public abstract class AbstractQueryStreamResult
extends AbstractPayload
implements QueryStreamResult {
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean initialized = false;
    protected volatile boolean closed = false;
    protected volatile List<ObObj> row = null;
    protected volatile int rowIndex = -1;
    protected ObTableQuery tableQuery;
    protected long operationTimeout = -1L;
    protected String tableName;
    protected String indexTableName;
    protected ObTableEntityType entityType;
    protected Map<Long, ObPair<Long, ObTableParam>> expectant;
    protected List<String> cacheProperties = new LinkedList<String>();
    protected LinkedList<List<ObObj>> cacheRows = new LinkedList();
    private LinkedList<ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>> partitionLastResult = new LinkedList();
    private ObReadConsistency readConsistency = ObReadConsistency.STRONG;

    @Override
    public int getPcode() {
        return 4356;
    }

    @Override
    public byte[] encode() {
        throw new FeatureNotSupportedException("stream result can not decode from bytes");
    }

    @Override
    public Object decode(ByteBuf buf) {
        throw new FeatureNotSupportedException("stream result can not decode from bytes");
    }

    @Override
    public long getPayloadContentSize() {
        throw new FeatureNotSupportedException("stream result has no pay load size");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ObPayload commonExecute(ObTableClient client, Logger logger, ObPair<Long, ObTableParam> partIdWithIndex, ObPayload request, AtomicReference<ObTableConnection> connectionRef) throws Exception {
        ObTable subObTable = partIdWithIndex.getRight().getObTable();
        boolean needRefreshTableEntry = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        HashSet<String> failedServerList = null;
        ObServerRoute route = null;
        while (true) {
            client.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > client.getRuntimeMaxWait()) {
                long uniqueId = request.getUniqueId();
                long sequence = request.getSequence();
                String trace = String.format("Y%X-%016X", uniqueId, sequence);
                throw new ObTableTimeoutExcetion("[" + trace + "] has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + client.getRuntimeMaxWait() + "/ms");
            }
            ++tryTimes;
            try {
                if (tryTimes > 1) {
                    if (client.isOdpMode()) {
                        subObTable = client.getOdpTable();
                    } else {
                        if (route == null) {
                            route = client.getReadRoute();
                        }
                        if (failedServerList != null) {
                            route.setBlackList(failedServerList);
                        }
                        subObTable = client.getTable(this.indexTableName, partIdWithIndex.getLeft(), needRefreshTableEntry, client.isTableEntryRefreshIntervalWait(), route).getRight().getObTable();
                    }
                }
                ObPayload result = client.isOdpMode() ? subObTable.executeWithConnection(request, connectionRef) : subObTable.execute(request);
                client.resetExecuteContinuousFailureCount(this.indexTableName);
                return result;
            }
            catch (Exception e) {
                block25: {
                    block26: {
                        if (!client.isOdpMode()) break block26;
                        if (tryTimes - 1 >= client.getRuntimeRetryTimes()) throw e;
                        if (e instanceof ObTableException) {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, errorCode: {}, errorMsg: {}, try times {}", new Object[]{this.indexTableName, ((ObTableException)e).getErrorCode(), e.getMessage(), tryTimes});
                            break block25;
                        } else if (e instanceof IllegalArgumentException) {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, try times {}, errorMsg: {}", new Object[]{this.indexTableName, tryTimes, e.getMessage()});
                            break block25;
                        } else {
                            logger.warn("tablename:{} stream query execute while meet Exception needing retry, try times {}", new Object[]{this.indexTableName, tryTimes, e});
                        }
                        break block25;
                    }
                    if (e instanceof ObTableReplicaNotReadableException) {
                        if (tryTimes - 1 >= client.getRuntimeRetryTimes()) {
                            logger.warn("tablename:{} partition id:{} exhaust retry when replica not readable: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), e.getMessage(), e});
                            throw e;
                        }
                        logger.warn("tablename:{} partition id:{} retry when replica not readable: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), e.getMessage(), e});
                        if (failedServerList == null) {
                            failedServerList = new HashSet<String>();
                        }
                        failedServerList.add(subObTable.getIp());
                    } else if (e instanceof ObTableGlobalIndexRouteException) {
                        if (tryTimes - 1 >= client.getRuntimeRetryTimes()) {
                            logger.warn("meet global index route expcetion: indexTableName:{} partition id:{}, errorCode: {}, reach max retry times {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), tryTimes, e});
                            throw e;
                        }
                        logger.warn("meet global index route expcetion: indexTableName:{} partition id:{}, errorCode: {}, retry times {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), tryTimes, e});
                        this.indexTableName = client.getIndexTableName(this.tableName, this.tableQuery.getIndexName(), this.tableQuery.getScanRangeColumns(), true);
                    } else {
                        if (!(e instanceof ObTableException)) {
                            client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                            throw e;
                        }
                        if ((((ObTableException)e).getErrorCode() == ResultCodes.OB_TABLE_NOT_EXIST.errorCode || ((ObTableException)e).getErrorCode() == ResultCodes.OB_NOT_SUPPORTED.errorCode) && ((ObTableQueryRequest)request).getTableQuery().isHbaseQuery() && client.getTableGroupInverted().get(this.indexTableName) != null) {
                            client.eraseTableGroupFromCache(this.tableName);
                        }
                        if (!((ObTableException)e).isNeedRefreshTableEntry()) {
                            client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                            throw e;
                        }
                        needRefreshTableEntry = true;
                        logger.warn("tablename:{} partition id:{} stream query refresh table while meet Exception needing refresh, errorCode: {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), e});
                        if (client.isRetryOnChangeMasterTimes() && tryTimes - 1 < client.getRuntimeRetryTimes()) {
                            logger.warn("tablename:{} partition id:{} stream query retry while meet Exception needing refresh, errorCode: {} , retry times {}", new Object[]{this.indexTableName, partIdWithIndex.getLeft(), ((ObTableException)e).getErrorCode(), tryTimes, e});
                        } else {
                            client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                            throw e;
                        }
                    }
                }
                Thread.sleep(client.getRuntimeRetryInterval());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws Exception {
        this.checkStatus();
        this.lock.lock();
        try {
            ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult> referLastResult;
            if (this.cacheRows.size() > 0) {
                this.nextRow();
                boolean bl = true;
                return bl;
            }
            while ((referLastResult = this.partitionLastResult.poll()) != null) {
                ObTableQueryResult lastResult = referLastResult.getRight();
                if (!lastResult.isStream() || !lastResult.isStreamNext()) continue;
                ObTableQueryResult tableQueryResult = this.referToLastStreamResult(referLastResult.getLeft(), lastResult);
                if (tableQueryResult.getRowCount() == 0L) continue;
                this.nextRow();
                boolean bl = true;
                return bl;
            }
            boolean hasNext = false;
            ArrayList<Map.Entry<Long, ObPair<Long, ObTableParam>>> referPartition = new ArrayList<Map.Entry<Long, ObPair<Long, ObTableParam>>>();
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : this.expectant.entrySet()) {
                referPartition.add(entry);
                ObTableQueryResult tableQueryResult = (ObTableQueryResult)this.referToNewPartition(entry.getValue());
                if (tableQueryResult.getRowCount() == 0L) continue;
                hasNext = true;
                this.nextRow();
                break;
            }
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : referPartition) {
                this.expectant.remove(entry.getKey());
            }
            boolean bl = hasNext;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void nextRow() {
        ++this.rowIndex;
        this.row = this.cacheRows.poll();
    }

    protected void checkStatus() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("table " + this.tableName + "query stream result is not initialized");
        }
        if (this.closed) {
            throw new IllegalStateException("table " + this.tableName + " query stream result is closed");
        }
    }

    protected ObTableQueryResult checkObTableQueryResult(Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableQueryResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName() + "expect " + ObTableQueryResult.class.getName());
        }
        return (ObTableQueryResult)result;
    }

    protected ObTableQueryAsyncResult checkObTableQueryAsyncResult(Object result) {
        if (result == null) {
            throw new ObTableException("client get unexpected NULL result");
        }
        if (!(result instanceof ObTableQueryAsyncResult)) {
            throw new ObTableException("client get unexpected result: " + result.getClass().getName() + "expect " + ObTableQueryAsyncResult.class.getName());
        }
        return (ObTableQueryAsyncResult)result;
    }

    private ObTableQueryResult referToLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult lastResult) throws Exception {
        ObTableStreamRequest streamRequest = new ObTableStreamRequest();
        streamRequest.setSessionId(lastResult.getSessionId());
        streamRequest.setStreamNext();
        if (this.operationTimeout > 0L) {
            streamRequest.setTimeout(this.operationTimeout);
        } else {
            streamRequest.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        return this.execute(partIdWithObTable, streamRequest);
    }

    private void closeLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult lastResult) throws Exception {
        ObTableStreamRequest streamRequest = new ObTableStreamRequest();
        streamRequest.setSessionId(lastResult.getSessionId());
        streamRequest.setStreamLast();
        if (this.operationTimeout > 0L) {
            streamRequest.setTimeout(this.operationTimeout);
        } else {
            streamRequest.setTimeout(partIdWithObTable.getRight().getObTable().getObTableOperationTimeout());
        }
        partIdWithObTable.getRight().getObTable().execute(streamRequest);
    }

    protected abstract ObPayload referToNewPartition(ObPair<Long, ObTableParam> var1) throws Exception;

    protected abstract ObTableQueryResult execute(ObPair<Long, ObTableParam> var1, ObPayload var2) throws Exception;

    protected abstract ObTableQueryAsyncResult executeAsync(ObPair<Long, ObTableParam> var1, ObPayload var2) throws Exception;

    protected void cacheResultRows(ObTableQueryResult tableQueryResult) {
        this.cacheRows.addAll(tableQueryResult.getPropertiesRows());
        this.cacheProperties = tableQueryResult.getPropertiesNames();
    }

    protected void cacheStreamNext(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryResult tableQueryResult) {
        this.cacheResultRows(tableQueryResult);
        if (tableQueryResult.isStream() && tableQueryResult.isStreamNext()) {
            this.partitionLastResult.addLast(new ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>(partIdWithObTable, tableQueryResult));
        }
    }

    private void cacheResultRows(ObTableQueryAsyncResult tableQueryAsyncResult) {
        this.cacheRows.addAll(tableQueryAsyncResult.getAffectedEntity().getPropertiesRows());
        this.cacheProperties = tableQueryAsyncResult.getAffectedEntity().getPropertiesNames();
    }

    protected void cacheStreamNext(ObPair<Long, ObTableParam> partIdWithObTable, ObTableQueryAsyncResult tableQueryAsyncResult) {
        this.cacheResultRows(tableQueryAsyncResult);
        if (tableQueryAsyncResult.getAffectedEntity().isStream() && tableQueryAsyncResult.getAffectedEntity().isStreamNext()) {
            this.partitionLastResult.addLast(new ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>(partIdWithObTable, tableQueryAsyncResult.getAffectedEntity()));
        }
    }

    @Override
    public List<ObObj> getRow() {
        if (this.rowIndex == -1) {
            throw new IllegalStateException("before result set start");
        }
        return this.row;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        if (this.tableQuery.getBatchSize() == -1) {
            for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : this.expectant.entrySet()) {
                this.referToNewPartition(entry.getValue());
            }
        } else {
            throw new ObTableException("simple query not support BatchSize, use executeAsync() instead, BatchSize:" + this.tableQuery.getBatchSize());
        }
        this.expectant.clear();
        this.initialized = true;
    }

    @Override
    public void close() throws Exception {
        ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult> referLastResult;
        if (this.closed) {
            return;
        }
        this.closed = true;
        while ((referLastResult = this.partitionLastResult.poll()) != null) {
            ObTableQueryResult lastResult = referLastResult.getRight();
            this.closeLastStreamResult(referLastResult.getLeft(), lastResult);
        }
    }

    @Override
    public List<String> getCacheProperties() {
        return this.cacheProperties;
    }

    @Override
    public LinkedList<List<ObObj>> getCacheRows() {
        return this.cacheRows;
    }

    public LinkedList<ObPair<ObPair<Long, ObTableParam>, ObTableQueryResult>> getPartitionLastResult() {
        return this.partitionLastResult;
    }

    public ObTableQuery getTableQuery() {
        return this.tableQuery;
    }

    public void setTableQuery(ObTableQuery tableQuery) {
        this.tableQuery = tableQuery;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexTableName() {
        return this.indexTableName;
    }

    public void setIndexTableName(String indexTableName) {
        this.indexTableName = indexTableName;
    }

    public ObTableEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(ObTableEntityType entityType) {
        this.entityType = entityType;
    }

    public Map<Long, ObPair<Long, ObTableParam>> getExpectant() {
        return this.expectant;
    }

    public void setExpectant(Map<Long, ObPair<Long, ObTableParam>> expectant) {
        this.expectant = expectant;
    }

    public ObReadConsistency getReadConsistency() {
        return this.readConsistency;
    }

    public void setReadConsistency(ObReadConsistency readConsistency) {
        this.readConsistency = readConsistency;
    }
}

