/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.stream;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.bolt.transport.ObTableConnection;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObQueryOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObTableClientQueryAsyncStreamResult
extends AbstractQueryStreamResult {
    private static final Logger logger = LoggerFactory.getLogger(ObTableClientQueryStreamResult.class);
    protected ObTableClient client;
    private boolean isEnd = true;
    private long sessionId = -1L;
    private ObTableQueryAsyncRequest asyncRequest = new ObTableQueryAsyncRequest();
    private ObTableConnection prevConnection = null;

    @Override
    public void init() throws Exception {
        if (this.initialized) {
            return;
        }
        ObTableQueryRequest request = new ObTableQueryRequest();
        request.setTableName(this.tableName);
        request.setTableQuery(this.tableQuery);
        request.setEntityType(this.entityType);
        request.setConsistencyLevel(this.getReadConsistency().toObTableConsistencyLevel());
        this.asyncRequest.setObTableQueryRequest(request);
        this.asyncRequest.setQueryType(ObQueryOperationType.QUERY_START);
        this.asyncRequest.setQuerySessionId(-1L);
        if (!this.expectant.isEmpty()) {
            Iterator it = this.expectant.entrySet().iterator();
            Map.Entry firstEntry = it.next();
            this.referToNewPartition((ObPair)firstEntry.getValue());
            if (this.isEnd()) {
                it.remove();
            }
        }
        this.initialized = true;
    }

    protected void cacheResultRows(ObTableQueryAsyncResult tableQueryResult) {
        this.cacheRows.clear();
        this.cacheRows.addAll(tableQueryResult.getAffectedEntity().getPropertiesRows());
        this.cacheProperties = tableQueryResult.getAffectedEntity().getPropertiesNames();
    }

    @Override
    protected ObTableQueryAsyncResult referToNewPartition(ObPair<Long, ObTableParam> partIdWithObTable) throws Exception {
        ObTableParam obTableParam = partIdWithObTable.getRight();
        ObTableQueryRequest queryRequest = this.asyncRequest.getObTableQueryRequest();
        queryRequest.setPartitionId(obTableParam.getPartitionId());
        queryRequest.setTableId(obTableParam.getTableId());
        if (this.operationTimeout > 0L) {
            queryRequest.setTimeout(this.operationTimeout);
        } else {
            queryRequest.setTimeout(obTableParam.getObTable().getObTableOperationTimeout());
        }
        this.asyncRequest.setQueryType(ObQueryOperationType.QUERY_START);
        this.asyncRequest.setQuerySessionId(-1L);
        ObTableQueryAsyncResult ret = this.executeAsync(partIdWithObTable, this.asyncRequest);
        return ret;
    }

    protected ObTableQueryAsyncResult referToLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable) throws Exception {
        ObTableParam obTableParam = partIdWithObTable.getRight();
        ObTableQueryRequest queryRequest = this.asyncRequest.getObTableQueryRequest();
        queryRequest.setPartitionId(obTableParam.getPartitionId());
        queryRequest.setTableId(obTableParam.getTableId());
        this.asyncRequest.setQueryType(ObQueryOperationType.QUERY_NEXT);
        this.asyncRequest.setQuerySessionId(this.sessionId);
        ObTableQueryAsyncResult ret = this.executeAsync(partIdWithObTable, this.asyncRequest);
        return ret;
    }

    protected void closeLastStreamResult(ObPair<Long, ObTableParam> partIdWithObTable) throws Exception {
        ObTableParam obTableParam = partIdWithObTable.getRight();
        ObTableQueryRequest queryRequest = this.asyncRequest.getObTableQueryRequest();
        queryRequest.setPartitionId(obTableParam.getPartitionId());
        queryRequest.setTableId(obTableParam.getTableId());
        this.asyncRequest.setQueryType(ObQueryOperationType.QUERY_END);
        this.asyncRequest.setQuerySessionId(this.sessionId);
        ObTableQueryAsyncResult ret = this.executeAsync(partIdWithObTable, this.asyncRequest);
        if (!this.isEnd()) {
            throw new ObTableException("failed to close last stream result");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws Exception {
        this.checkStatus();
        this.lock.lock();
        try {
            if (!this.cacheRows.isEmpty()) {
                this.nextRow();
                boolean bl = true;
                return bl;
            }
            if (!this.isEnd() && !this.expectant.isEmpty()) {
                Iterator it = this.expectant.entrySet().iterator();
                Map.Entry lastEntry = it.next();
                this.referToLastStreamResult((ObPair)lastEntry.getValue());
                if (this.isEnd()) {
                    it.remove();
                }
                if (!this.cacheRows.isEmpty()) {
                    this.nextRow();
                    boolean bl = true;
                    return bl;
                }
            }
            boolean hasNext = false;
            Iterator it = this.expectant.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.referToNewPartition((ObPair)entry.getValue());
                if (this.isEnd()) {
                    it.remove();
                }
                if (this.cacheRows.isEmpty()) continue;
                hasNext = true;
                this.nextRow();
                break;
            }
            boolean bl = hasNext;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected ObTableQueryResult execute(ObPair<Long, ObTableParam> partIdWithObTable, ObPayload streamRequest) throws Exception {
        throw new IllegalArgumentException("not support this execute");
    }

    @Override
    protected ObTableQueryAsyncResult executeAsync(ObPair<Long, ObTableParam> partIdWithObTable, ObPayload streamRequest) throws Exception {
        AtomicReference<ObTableConnection> connectionRef = new AtomicReference<ObTableConnection>();
        if (this.client.isOdpMode() && !this.isEnd && this.prevConnection != null) {
            connectionRef.set(this.prevConnection);
        }
        ObTableQueryAsyncResult result = (ObTableQueryAsyncResult)this.commonExecute(this.client, logger, partIdWithObTable, streamRequest, connectionRef);
        this.cacheResultRows(result);
        if (result.isEnd()) {
            this.isEnd = true;
        } else {
            this.isEnd = false;
            this.prevConnection = connectionRef.get();
        }
        this.sessionId = result.getSessionId();
        return result;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.isEnd() && !this.expectant.isEmpty()) {
            Iterator it = this.expectant.entrySet().iterator();
            Map.Entry lastEntry = it.next();
            this.closeLastStreamResult((ObPair)lastEntry.getValue());
        }
    }

    public ObTableClient getClient() {
        return this.client;
    }

    public void setClient(ObTableClient client) {
        this.client = client;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean end) {
        this.isEnd = end;
    }
}

