/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamePattern {
    private static final String HOLDER_FIRST = "#F#";
    private static final String HOLDER_SECOND = "#S#";
    private String patternString;
    private String patternHolder;
    private int valueAlignLenFirst = 0;
    private int valueAlignLenSecond = 0;
    private int minValue;
    private int maxValue;
    private int startValueFirst;
    private int endValueFirst;
    private int startValueSecond;
    private int endValueSecond;
    private int valueRangeSecond;
    private boolean hasTwoColumn = false;

    public NamePattern(String patternString) {
        this.patternString = patternString;
        String regex = "\\{\\d+-\\d+\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(patternString);
        int i = 0;
        while (matcher.find()) {
            if (i == 0) {
                this.parseFirst(matcher.group(0));
                patternString = StringUtil.replaceOnce(patternString, matcher.group(0), HOLDER_FIRST);
            } else {
                this.hasTwoColumn = true;
                this.parseSecond(matcher.group(0));
                patternString = StringUtil.replaceOnce(patternString, matcher.group(0), HOLDER_SECOND);
                if (this.startValueFirst > 0 || this.startValueSecond > 0) {
                    throw new IllegalArgumentException("two column NamePattern cannot start from non-zero value: " + this.patternString);
                }
            }
            ++i;
        }
        this.patternHolder = patternString;
    }

    private void parseFirst(String pattern) {
        int index0 = 0;
        int index1 = pattern.length() - 1;
        int index2 = pattern.indexOf(45, index0);
        this.valueAlignLenFirst = index2 - index0 - 1;
        this.startValueFirst = Integer.parseInt(pattern.substring(index0 + 1, index2));
        this.endValueFirst = Integer.parseInt(pattern.substring(index2 + 1, index1));
        this.minValue = this.startValueFirst;
        this.maxValue = this.endValueFirst;
    }

    private void parseSecond(String pattern) {
        int index0 = 0;
        int index1 = pattern.length() - 1;
        int index2 = pattern.indexOf(45, index0);
        this.valueAlignLenSecond = index2 - index0 - 1;
        this.startValueSecond = Integer.parseInt(pattern.substring(index0 + 1, index2));
        this.endValueSecond = Integer.parseInt(pattern.substring(index2 + 1, index1));
        this.valueRangeSecond = this.endValueSecond - this.startValueSecond + 1;
        this.minValue = this.startValueFirst * this.valueRangeSecond + this.startValueSecond;
        this.maxValue = this.endValueFirst * this.valueRangeSecond + this.endValueSecond + 1;
    }

    public String wrapValue(int value) {
        int firstValue = value;
        int secondValue = -1;
        if (this.hasTwoColumn) {
            firstValue = value / this.valueRangeSecond;
            secondValue = value % this.valueRangeSecond;
        }
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("NamePattern value out of bound. value: " + value + ", minValue: " + this.minValue + ", maxValue: " + this.maxValue + ", pattern: " + this.patternString);
        }
        String firstReplaced = StringUtil.replaceOnce(this.patternHolder, HOLDER_FIRST, StringUtil.alignRight(String.valueOf(firstValue), this.valueAlignLenFirst, "0"));
        if (!this.hasTwoColumn) {
            return firstReplaced;
        }
        return StringUtil.replaceOnce(firstReplaced, HOLDER_SECOND, StringUtil.alignRight(String.valueOf(secondValue), this.valueAlignLenSecond, "0"));
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getSize() {
        return this.maxValue - this.minValue + 1;
    }
}

