/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.batch;

import com.alipay.oceanbase.rpc.batch.QueryByBatch;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.QueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QueryByBatchResultSet
implements QueryStreamResult {
    private final QueryByBatch queryByBatch;
    private QueryResultSet resultSet = null;
    private int resultSize;

    public QueryByBatchResultSet(QueryByBatch queryByBatch) {
        this.queryByBatch = queryByBatch;
    }

    @Override
    public boolean next() throws Exception {
        boolean res;
        if (this.resultSet == null) {
            this.resultSet = this.queryByBatch.getTableQuery().execute();
            this.resultSize = this.resultSet.cacheSize();
        }
        if (!(res = this.resultSet.next()) && this.resultSize > 0) {
            Map<String, Object> row = this.resultSet.getRow();
            this.updateQuery(row, this.queryByBatch.getTableQuery());
            this.refreshExecute();
            res = this.resultSet.next();
        }
        return res;
    }

    @Override
    public List<ObObj> getRow() {
        return this.resultSet.getQueryStreamResult().getRow();
    }

    private void updateQuery(Map<String, Object> row, TableQuery tableQuery) {
        List<ObNewRange> ranges = tableQuery.getObTableQuery().getKeyRanges();
        ranges.clear();
        int keyLen = this.queryByBatch.getEnd().length;
        Object[] newBegin = new Object[keyLen];
        for (int i = 0; i < keyLen; ++i) {
            newBegin[i] = row.get(this.queryByBatch.getKeys()[i]);
        }
        tableQuery.addScanRange(newBegin, false, this.queryByBatch.getEnd(), this.queryByBatch.isEndEquals());
    }

    private void refreshExecute() throws Exception {
        this.resultSet = this.queryByBatch.getTableQuery().execute();
        this.resultSize = this.resultSet.cacheSize();
    }

    @Override
    public int getRowIndex() {
        return this.resultSet.getQueryStreamResult().getRowIndex();
    }

    @Override
    public LinkedList<List<ObObj>> getCacheRows() {
        if (this.resultSet == null) {
            return new LinkedList<List<ObObj>>();
        }
        return this.resultSet.getQueryStreamResult().getCacheRows();
    }

    @Override
    public List<String> getCacheProperties() {
        return this.resultSet.getQueryStreamResult().getCacheProperties();
    }

    @Override
    public void init() throws Exception {
        this.resultSet.getQueryStreamResult().init();
    }

    @Override
    public void close() throws Exception {
        this.resultSet.getQueryStreamResult().close();
    }
}

