/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.protocol;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.oceanbase.rpc.bolt.protocol.ObTableProtocol;
import com.alipay.oceanbase.rpc.util.Serialization;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import com.alipay.remoting.CommandEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import org.slf4j.Logger;

public class ObTablePacketEncoder
implements CommandEncoder {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTablePacketEncoder.class);

    public void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        try {
            if (msg instanceof ObTablePacket) {
                ObTablePacket cmd = (ObTablePacket)((Object)msg);
                out.writeBytes(ObTableProtocol.MAGIC_HEADER_FLAG);
                out.writeBytes(Serialization.encodeI32(cmd.getPacketContent().length));
                out.writeBytes(Serialization.encodeI32(cmd.getId()));
                out.writeBytes(ObTableProtocol.RESERVED);
                out.writeBytes(cmd.getPacketContent());
            } else {
                String warnMsg = "msg type [" + msg.getClass() + "] is not subclass of ObCommand";
                logger.warn(warnMsg);
            }
        }
        catch (Exception e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00003"), (Throwable)e);
            throw e;
        }
    }
}

