/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.transport;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.oceanbase.rpc.bolt.transport.ObTablePacketProcessor;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import com.alipay.remoting.CommandCode;
import com.alipay.remoting.CommandHandler;
import com.alipay.remoting.RemotingContext;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.rpc.RpcCommand;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;

public class ObTablePacketHandler
implements CommandHandler {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTablePacketHandler.class);
    private final ObTablePacketProcessor processor = new ObTablePacketProcessor();

    public void handleCommand(RemotingContext ctx, Object msg) {
        try {
            if (msg instanceof List) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Batch message! size={}", (Object)((List)msg).size());
                }
                for (Object m : (List)msg) {
                    this.processor.process(ctx, (ObTablePacket)m, (ExecutorService)null);
                }
            } else {
                this.processor.process(ctx, (ObTablePacket)msg, (ExecutorService)null);
            }
        }
        catch (Throwable e) {
            this.processException(msg, e);
        }
    }

    private void processException(Object msg, Throwable t) {
        if (msg instanceof List) {
            for (Object m : (List)msg) {
                this.processExceptionForSingleCommand(m, t);
            }
        } else {
            this.processExceptionForSingleCommand(msg, t);
        }
    }

    private void processExceptionForSingleCommand(Object msg, Throwable t) {
        int id = ((RpcCommand)msg).getId();
        logger.error(TableClientLoggerFactory.LCD.convert("01-00021"), (Object)id, (Object)t);
    }

    public void registerProcessor(CommandCode cmd, RemotingProcessor<?> processor) {
        throw new IllegalArgumentException("not support yet");
    }

    public void registerDefaultExecutor(ExecutorService executor) {
        throw new IllegalArgumentException("not support yet");
    }

    public ExecutorService getDefaultExecutor() {
        throw new IllegalArgumentException("not support yet");
    }
}

