/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import java.util.concurrent.atomic.AtomicInteger;

public class ObServerAddr
implements Comparable<ObServerAddr> {
    private String ip;
    private int sqlPort;
    private int svrPort;
    private final AtomicInteger priority = new AtomicInteger(0);
    private volatile long grantPriorityTime = 0L;
    private volatile long lastAccessTime = System.currentTimeMillis();

    public boolean isExpired(long cachingTimeout) {
        return System.currentTimeMillis() - this.lastAccessTime > cachingTimeout;
    }

    public void recordAccess() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setAddress(String address) {
        if (address.contains(":")) {
            this.ip = address.split(":")[0];
            this.svrPort = Integer.parseInt(address.split(":")[1]);
        } else {
            this.ip = address;
        }
    }

    public int getSqlPort() {
        return this.sqlPort;
    }

    public void setSqlPort(int sqlPort) {
        this.sqlPort = sqlPort;
    }

    public int getSvrPort() {
        return this.svrPort;
    }

    public void setSvrPort(int svrPort) {
        this.svrPort = svrPort;
    }

    public AtomicInteger getPriority() {
        return this.priority;
    }

    public long getGrantPriorityTime() {
        return this.grantPriorityTime;
    }

    public void setGrantPriorityTime(long grantPriorityTime) {
        this.grantPriorityTime = grantPriorityTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObServerAddr that = (ObServerAddr)o;
        return this.sqlPort == that.sqlPort && this.svrPort == that.svrPort && this.ip.equals(that.ip);
    }

    public int hashCode() {
        return this.ip.hashCode() + this.sqlPort + this.svrPort;
    }

    public String toString() {
        return "ObServerAddr{ip='" + this.ip + '\'' + ", sqlPort=" + this.sqlPort + ", svrPort=" + this.svrPort + '}';
    }

    @Override
    public int compareTo(ObServerAddr that) {
        int thatValue;
        int thisValue = this.priority.get();
        return thisValue < (thatValue = that.priority.get()) ? 1 : (thisValue == thatValue ? 0 : -1);
    }
}

