/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartFuncType;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObColumn;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObSimpleColumn;
import com.alipay.oceanbase.rpc.util.StringUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class ObPartDesc {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObPartDesc.class);
    private ObPartFuncType partFuncType = ObPartFuncType.UNKNOWN;
    private String partExpr = "";
    protected List<String> orderedPartColumnNames = Collections.EMPTY_LIST;
    protected List<ObPair<ObColumn, List<Integer>>> orderedPartRefColumnRowKeyRelations = Collections.EMPTY_LIST;
    protected List<ObColumn> partColumns = Collections.EMPTY_LIST;
    private Map<String, Long> partNameIdMap = null;
    public static final ObPartitionKey DEFAULT_PART_KEY = ObPartitionKey.getInstance(Collections.singletonList(ObSimpleColumn.DEFAULT_UTF8MB4_GENERAL_CI), new Comparable[]{"default"});
    protected Map<String, Integer> rowKeyElement = Collections.EMPTY_MAP;

    public ObPartFuncType getPartFuncType() {
        return this.partFuncType;
    }

    public void setPartFuncType(ObPartFuncType partFuncType) {
        this.partFuncType = partFuncType;
    }

    public String getPartExpr() {
        return this.partExpr;
    }

    public void setPartExpr(String partExpr) {
        if (StringUtil.isBlank(partExpr)) {
            throw new IllegalArgumentException("ObKeyPartDesc part express is blank");
        }
        this.partExpr = partExpr.replace(" ", "");
        this.orderedPartColumnNames = Collections.unmodifiableList(Arrays.asList(this.partExpr.split(",")));
    }

    public int getPartNum() {
        return -1;
    }

    public List<String> getOrderedPartColumnNames() {
        return this.orderedPartColumnNames;
    }

    public List<ObColumn> getPartColumns() {
        return this.partColumns;
    }

    public void setPartColumns(List<ObColumn> partColumns) {
        this.partColumns = partColumns;
    }

    public Map<String, Long> getPartNameIdMap() {
        return this.partNameIdMap;
    }

    public void setPartNameIdMap(Map<String, Long> partNameIdMap) {
        this.partNameIdMap = partNameIdMap;
    }

    public Map<String, Integer> getRowKeyElement() {
        return this.rowKeyElement;
    }

    public void setRowKeyElement(Map<String, Integer> rowKeyElement) {
        this.rowKeyElement = rowKeyElement;
    }

    protected List<Comparable> initComparableElementByTypes(List<Object> objects, List<ObColumn> obColumns) {
        ArrayList<Comparable> comparableElement = new ArrayList<Comparable>(objects.size());
        try {
            for (int i = 0; i < objects.size(); ++i) {
                ObColumn obColumn = obColumns.get(i);
                comparableElement.add(obColumn.getObObjType().parseToComparable(objects.get(i), obColumn.getObCollationType()));
            }
        }
        catch (Exception e) {
            logger.error(TableClientLoggerFactory.LCD.convert("01-00024"), new Object[]{objects, obColumns, e});
            throw new IllegalArgumentException(String.format("failed to cast obj, obj=%s, types=%s", objects, obColumns), e);
        }
        return comparableElement;
    }

    public void prepare() throws IllegalArgumentException {
        if (this.orderedPartColumnNames == Collections.EMPTY_LIST) {
            throw new IllegalArgumentException("prepare ObPartDesc failed. orderedPartColumnNames is empty");
        }
        if (this.rowKeyElement == null || this.rowKeyElement.size() == 0) {
            throw new IllegalArgumentException("prepare ObPartDesc failed. rowKeyElement is empty");
        }
        if (this.partColumns == null || this.partColumns.size() == 0) {
            throw new IllegalArgumentException("prepare ObPartDesc failed. partColumns is empty");
        }
        ArrayList<ObPair<ObColumn, List<Integer>>> orderPartRefColumnRowKeyRelations = new ArrayList<ObPair<ObColumn, List<Integer>>>(this.orderedPartColumnNames.size());
        for (String partOrderColumnName : this.orderedPartColumnNames) {
            for (ObColumn column : this.partColumns) {
                if (!column.getColumnName().equalsIgnoreCase(partOrderColumnName)) continue;
                ArrayList<Integer> partRefColumnRowKeyIndexes = new ArrayList<Integer>(column.getRefColumnNames().size());
                for (String refColumn : column.getRefColumnNames()) {
                    boolean rowKeyElementRefer = false;
                    for (String rowKeyElementName : this.rowKeyElement.keySet()) {
                        if (!rowKeyElementName.equalsIgnoreCase(refColumn)) continue;
                        partRefColumnRowKeyIndexes.add(this.rowKeyElement.get(rowKeyElementName));
                        rowKeyElementRefer = true;
                    }
                    if (rowKeyElementRefer) continue;
                    throw new IllegalArgumentException("partition order column " + partOrderColumnName + " refer to non-row-key column " + refColumn);
                }
                orderPartRefColumnRowKeyRelations.add(new ObPair(column, partRefColumnRowKeyIndexes));
            }
        }
        this.orderedPartRefColumnRowKeyRelations = orderPartRefColumnRowKeyRelations;
    }

    public List<Object> evalRowKeyValues(Object ... rowKey) throws IllegalArgumentException {
        int partRefColumnSize = this.orderedPartRefColumnRowKeyRelations.size();
        ArrayList<Object> evalValues = new ArrayList<Object>(partRefColumnSize);
        for (int i = 0; i < partRefColumnSize; ++i) {
            ObPair<ObColumn, List<Integer>> orderedPartRefColumnRowKeyRelation = this.orderedPartRefColumnRowKeyRelations.get(i);
            if (rowKey.length < this.rowKeyElement.size()) {
                throw new IllegalArgumentException("row key is consist of " + this.rowKeyElement + "but found" + Arrays.toString(rowKey));
            }
            Object[] partKey = Arrays.copyOfRange(rowKey, 0, this.rowKeyElement.size());
            List<Integer> refIndex = orderedPartRefColumnRowKeyRelation.getRight();
            Object[] evalParams = new Object[refIndex.size()];
            for (int j = 0; j < refIndex.size(); ++j) {
                evalParams[j] = partKey[refIndex.get(j)];
            }
            evalValues.add(orderedPartRefColumnRowKeyRelation.getLeft().evalValue(evalParams));
        }
        return evalValues;
    }

    public abstract List<Long> getPartIds(Object[] var1, boolean var2, Object[] var3, boolean var4) throws IllegalArgumentException;

    public abstract Long getPartId(Object ... var1) throws IllegalArgumentException;

    public abstract Long getPartId(List<Object[]> var1, boolean var2) throws IllegalArgumentException, ObTablePartitionConsistentException;

    public abstract Long getRandomPartId();

    public abstract void setPartNum(int var1);
}

