/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.mutation;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.checkandmutate.CheckAndInsUp;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.mutation.Append;
import com.alipay.oceanbase.rpc.mutation.Increment;
import com.alipay.oceanbase.rpc.mutation.Insert;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.Replace;
import com.alipay.oceanbase.rpc.mutation.Update;
import com.alipay.oceanbase.rpc.mutation.result.BatchOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.table.ObTableClientLSBatchOpsImpl;
import com.alipay.oceanbase.rpc.table.api.Table;
import com.alipay.oceanbase.rpc.table.api.TableBatchOps;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatchOperation {
    private String tableName;
    private Table client;
    boolean withResult;
    private List<Object> operations;
    boolean isAtomic = false;
    boolean hasCheckAndInsUp = false;

    public BatchOperation() {
        this.tableName = null;
        this.client = null;
        this.withResult = false;
        this.operations = new ArrayList<Object>();
    }

    public BatchOperation(Table client, String tableName) {
        this.tableName = tableName;
        this.client = client;
        this.withResult = false;
        this.operations = new ArrayList<Object>();
    }

    public BatchOperation setClient(Table client) {
        this.client = client;
        return this;
    }

    public BatchOperation setTable(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public BatchOperation addOperation(TableQuery ... queries) {
        this.operations.addAll(Arrays.asList(queries));
        return this;
    }

    public BatchOperation addOperation(Mutation ... mutations) {
        this.operations.addAll(Arrays.asList(mutations));
        return this;
    }

    public BatchOperation addOperation(List<Mutation> mutations) {
        this.operations.addAll(mutations);
        return this;
    }

    public BatchOperation addOperation(CheckAndInsUp ... insUps) {
        this.operations.addAll(Arrays.asList(insUps));
        this.hasCheckAndInsUp = true;
        return this;
    }

    public BatchOperation setIsAtomic(boolean isAtomic) {
        this.isAtomic = isAtomic;
        return this;
    }

    public BatchOperationResult execute() throws Exception {
        if (this.hasCheckAndInsUp) {
            return this.executeWithLSBatchOp();
        }
        return this.executeWithNormalBatchOp();
    }

    public BatchOperationResult executeWithNormalBatchOp() throws Exception {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        TableBatchOps batchOps = this.client.batch(this.tableName);
        boolean hasSetRowkeyElement = false;
        for (Object operation : this.operations) {
            if (operation instanceof Mutation) {
                Mutation mutation = (Mutation)operation;
                if (!hasSetRowkeyElement && mutation.getRowKeyNames() != null) {
                    List<String> rowKeyNames = mutation.getRowKeyNames();
                    ((ObTableClient)this.client).addRowKeyElement(this.tableName, rowKeyNames.toArray(new String[0]));
                    hasSetRowkeyElement = true;
                }
                ObTableOperationType type = mutation.getOperationType();
                switch (type) {
                    case GET: {
                        throw new IllegalArgumentException("Invalid type in batch operation, " + (Object)((Object)type));
                    }
                    case INSERT: {
                        ((Insert)mutation).removeRowkeyFromMutateColval();
                        batchOps.insert(mutation.getRowKey(), ((Insert)mutation).getColumns(), ((Insert)mutation).getValues());
                        break;
                    }
                    case DEL: {
                        batchOps.delete(mutation.getRowKey());
                        break;
                    }
                    case UPDATE: {
                        ((Update)mutation).removeRowkeyFromMutateColval();
                        batchOps.update(mutation.getRowKey(), ((Update)mutation).getColumns(), ((Update)mutation).getValues());
                        break;
                    }
                    case INSERT_OR_UPDATE: {
                        ((InsertOrUpdate)mutation).removeRowkeyFromMutateColval();
                        batchOps.insertOrUpdate(mutation.getRowKey(), ((InsertOrUpdate)mutation).getColumns(), ((InsertOrUpdate)mutation).getValues());
                        break;
                    }
                    case REPLACE: {
                        ((Replace)mutation).removeRowkeyFromMutateColval();
                        batchOps.replace(mutation.getRowKey(), ((Replace)mutation).getColumns(), ((Replace)mutation).getValues());
                        break;
                    }
                    case INCREMENT: {
                        ((Increment)mutation).removeRowkeyFromMutateColval();
                        batchOps.increment(mutation.getRowKey(), ((Increment)mutation).getColumns(), ((Increment)mutation).getValues(), this.withResult);
                        break;
                    }
                    case APPEND: {
                        ((Append)mutation).removeRowkeyFromMutateColval();
                        batchOps.append(mutation.getRowKey(), ((Append)mutation).getColumns(), ((Append)mutation).getValues(), this.withResult);
                        break;
                    }
                    default: {
                        throw new ObTableException("unknown operation type " + (Object)((Object)type));
                    }
                }
                continue;
            }
            if (operation instanceof TableQuery) {
                TableQuery query = (TableQuery)operation;
                batchOps.get(query.getRowKey().getValues(), query.getSelectColumns().toArray(new String[0]));
                continue;
            }
            throw new ObTableException("unknown operation " + operation);
        }
        batchOps.setAtomicOperation(this.isAtomic);
        return new BatchOperationResult(batchOps.executeWithResult());
    }

    public BatchOperationResult executeWithLSBatchOp() throws Exception {
        ObTableClientLSBatchOpsImpl batchOps;
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        if (this.client instanceof ObTableClient) {
            batchOps = new ObTableClientLSBatchOpsImpl(this.tableName, (ObTableClient)this.client);
            boolean hasSetRowkeyElement = false;
            for (Object operation : this.operations) {
                if (operation instanceof CheckAndInsUp) {
                    CheckAndInsUp checkAndInsUp = (CheckAndInsUp)operation;
                    batchOps.addOperation(checkAndInsUp);
                    List<String> rowKeyNames = checkAndInsUp.getInsUp().getRowKeyNames();
                    if (hasSetRowkeyElement || rowKeyNames == null) continue;
                    ((ObTableClient)this.client).addRowKeyElement(this.tableName, rowKeyNames.toArray(new String[0]));
                    hasSetRowkeyElement = true;
                    continue;
                }
                throw new IllegalArgumentException("The operations in batch must be all checkAndInsUp or all non-checkAndInsUp");
            }
        } else {
            throw new IllegalArgumentException("execute batch using ObTable diretly is not supporeted");
        }
        return new BatchOperationResult(batchOps.executeWithResult());
    }
}

