/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl;

import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjMeta;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObjType;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public enum ObTableObjType {
    ObTableNullType(0){}
    ,
    ObTableTinyIntType(1){}
    ,
    ObTableSmallIntType(2){}
    ,
    ObTableInt32Type(3){}
    ,
    ObTableInt64Type(4){}
    ,
    ObTableVarcharType(5){}
    ,
    ObTableVarbinaryType(6){

        @Override
        public void decode(ByteBuf buf, ObObj obj) {
            ObObjType objType = 7.getObjType(this);
            ObObjMeta objMeta = objType.getDefaultObjMeta();
            objMeta.setCsType(ObCollationType.CS_TYPE_BINARY);
            obj.setMeta(objMeta);
            obj.setValue(objType.decode(buf, objMeta.getCsType()));
        }
    }
    ,
    ObTableDoubleType(7){}
    ,
    ObTableFloatType(8){}
    ,
    ObTableTimestampType(9){

        @Override
        public byte[] encode(ObObj obj) {
            return this.encodeWithMeta(obj);
        }

        @Override
        public void decode(ByteBuf buf, ObObj obj) {
            this.decodeWithMeta(buf, obj);
        }

        @Override
        public int getEncodedSize(ObObj obj) {
            return this.getEncodedSizeWithMeta(obj);
        }
    }
    ,
    ObTableDateTimeType(10){

        @Override
        public byte[] encode(ObObj obj) {
            return this.encodeWithMeta(obj);
        }

        @Override
        public void decode(ByteBuf buf, ObObj obj) {
            this.decodeWithMeta(buf, obj);
        }

        @Override
        public int getEncodedSize(ObObj obj) {
            return this.getEncodedSizeWithMeta(obj);
        }
    }
    ,
    ObTableMinType(11){

        @Override
        public byte[] encode(ObObj obj) {
            byte[] bytes = new byte[this.getEncodedSize(obj)];
            int idx = 0;
            System.arraycopy(Serialization.encodeI8(this.getValue()), 0, bytes, idx, 1);
            ++idx;
            return bytes;
        }

        @Override
        public void decode(ByteBuf buf, ObObj obj) {
            ObObjType objType = 12.getObjType(this);
            ObObjMeta objMeta = objType.getDefaultObjMeta();
            obj.setMeta(objMeta);
            obj.setValue(-2L);
        }

        @Override
        public int getEncodedSize(ObObj obj) {
            return DEFAULT_TABLE_OBJ_TYPE_SIZE;
        }
    }
    ,
    ObTableMaxType(12){

        @Override
        public byte[] encode(ObObj obj) {
            byte[] bytes = new byte[this.getEncodedSize(obj)];
            int idx = 0;
            System.arraycopy(Serialization.encodeI8(this.getValue()), 0, bytes, idx, 1);
            ++idx;
            return bytes;
        }

        @Override
        public void decode(ByteBuf buf, ObObj obj) {
            ObObjType objType = 13.getObjType(this);
            ObObjMeta objMeta = objType.getDefaultObjMeta();
            obj.setMeta(objMeta);
            obj.setValue(-3L);
        }

        @Override
        public int getEncodedSize(ObObj obj) {
            return DEFAULT_TABLE_OBJ_TYPE_SIZE;
        }
    }
    ,
    ObTableInvalidType(17){};

    private int value;
    private static Map<Integer, ObTableObjType> map;
    public static int DEFAULT_TABLE_OBJ_TYPE_SIZE;
    public static int DEFAULT_TABLE_OBJ_META_SIZE;

    private ObTableObjType(int value) {
        this.value = value;
    }

    public static ObTableObjType getTableObjType(ObObj obj) {
        ObObjType objType = obj.getMeta().getType();
        ObCollationType objCsType = obj.getMeta().getCsType();
        if (objType == ObObjType.ObNullType) {
            return ObTableNullType;
        }
        if (objType == ObObjType.ObTinyIntType) {
            return ObTableTinyIntType;
        }
        if (objType == ObObjType.ObSmallIntType) {
            return ObTableSmallIntType;
        }
        if (objType == ObObjType.ObInt32Type) {
            return ObTableInt32Type;
        }
        if (objType == ObObjType.ObInt64Type) {
            return ObTableInt64Type;
        }
        if (objType == ObObjType.ObVarcharType) {
            if (objCsType == ObCollationType.CS_TYPE_BINARY) {
                return ObTableVarbinaryType;
            }
            return ObTableVarcharType;
        }
        if (objType == ObObjType.ObDoubleType) {
            return ObTableDoubleType;
        }
        if (objType == ObObjType.ObFloatType) {
            return ObTableFloatType;
        }
        if (objType == ObObjType.ObTimestampType) {
            return ObTableTimestampType;
        }
        if (objType == ObObjType.ObDateTimeType) {
            return ObTableDateTimeType;
        }
        if (objType == ObObjType.ObExtendType) {
            if (obj.isMinObj()) {
                return ObTableMinType;
            }
            if (obj.isMaxObj()) {
                return ObTableMaxType;
            }
        }
        throw new IllegalArgumentException("cannot get ObTableObjType, invalid ob obj type: " + ((Object)((Object)objType)).getClass().getName());
    }

    public static ObObjType getObjType(ObTableObjType tableObjType) {
        if (tableObjType == ObTableNullType) {
            return ObObjType.ObNullType;
        }
        if (tableObjType == ObTableTinyIntType) {
            return ObObjType.ObTinyIntType;
        }
        if (tableObjType == ObTableSmallIntType) {
            return ObObjType.ObSmallIntType;
        }
        if (tableObjType == ObTableInt32Type) {
            return ObObjType.ObInt32Type;
        }
        if (tableObjType == ObTableInt64Type) {
            return ObObjType.ObInt64Type;
        }
        if (tableObjType == ObTableVarcharType) {
            return ObObjType.ObVarcharType;
        }
        if (tableObjType == ObTableVarbinaryType) {
            return ObObjType.ObVarcharType;
        }
        if (tableObjType == ObTableDoubleType) {
            return ObObjType.ObDoubleType;
        }
        if (tableObjType == ObTableFloatType) {
            return ObObjType.ObFloatType;
        }
        if (tableObjType == ObTableTimestampType) {
            return ObObjType.ObTimestampType;
        }
        if (tableObjType == ObTableDateTimeType) {
            return ObObjType.ObDateTimeType;
        }
        if (tableObjType == ObTableMinType || tableObjType == ObTableMaxType) {
            return ObObjType.ObExtendType;
        }
        throw new IllegalArgumentException("cannot get ObTableObjType, invalid table obj type: " + ((Object)((Object)tableObjType)).getClass().getName());
    }

    public static ObTableObjType valueOf(int value) {
        return map.get(value);
    }

    public byte getValue() {
        return (byte)this.value;
    }

    public byte[] encode(ObObj obj) {
        ObObjType objType = obj.getMeta().getType();
        byte[] bytes = new byte[this.getEncodedSize(obj)];
        int idx = 0;
        System.arraycopy(Serialization.encodeI8(this.getValue()), 0, bytes, idx, 1);
        byte[] valueBytes = objType.encode(obj.getValue());
        System.arraycopy(valueBytes, 0, bytes, ++idx, valueBytes.length);
        idx += valueBytes.length;
        return bytes;
    }

    public void decode(ByteBuf buf, ObObj obj) {
        ObObjType objType = ObTableObjType.getObjType(this);
        ObObjMeta objMeta = objType.getDefaultObjMeta();
        obj.setMeta(objMeta);
        obj.setValue(objType.decode(buf, objMeta.getCsType()));
    }

    public int getEncodedSize(ObObj obj) {
        ObObjType objType = obj.getMeta().getType();
        return DEFAULT_TABLE_OBJ_TYPE_SIZE + objType.getEncodedSize(obj.getValue());
    }

    public byte[] encodeWithMeta(ObObj obj) {
        ObObjType objType = obj.getMeta().getType();
        ObTableObjType tableObjType = ObTableObjType.getTableObjType(obj);
        byte[] bytes = new byte[tableObjType.getEncodedSize(obj)];
        int idx = 0;
        System.arraycopy(Serialization.encodeI8(tableObjType.getValue()), 0, bytes, idx, 1);
        System.arraycopy(Serialization.encodeI8(obj.getMeta().getCsLevel().getByteValue()), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(obj.getMeta().getCsType().getByteValue()), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(obj.getMeta().getScale()), 0, bytes, ++idx, 1);
        byte[] valueBytes = objType.encode(obj.getValue());
        System.arraycopy(valueBytes, 0, bytes, ++idx, valueBytes.length);
        idx += valueBytes.length;
        return bytes;
    }

    public void decodeWithMeta(ByteBuf buf, ObObj obj) {
        ObObjType objType = ObTableObjType.getObjType(this);
        ObObjMeta meta = obj.getMeta();
        meta.setType(objType);
        meta.setCsLevel(ObCollationLevel.valueOf(Serialization.decodeI8(buf.readByte())));
        meta.setCsType(ObCollationType.valueOf(Serialization.decodeI8(buf.readByte())));
        meta.setScale(Serialization.decodeI8(buf.readByte()));
        obj.setValue(objType.decode(buf, meta.getCsType()));
    }

    public int getEncodedSizeWithMeta(ObObj obj) {
        ObObjType objType = ObTableObjType.getObjType(this);
        int len = DEFAULT_TABLE_OBJ_META_SIZE + objType.getEncodedSize(obj.getValue());
        return len;
    }

    static {
        map = new HashMap<Integer, ObTableObjType>();
        for (ObTableObjType type : ObTableObjType.values()) {
            map.put(type.value, type);
        }
        DEFAULT_TABLE_OBJ_TYPE_SIZE = 1;
        DEFAULT_TABLE_OBJ_META_SIZE = 4;
    }
}

