/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.column;

import com.alipay.oceanbase.rpc.protocol.payload.impl.ObCollationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.column.ObGeneratedColumnSimpleFunc;
import com.alipay.oceanbase.rpc.util.Serialization;
import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObGeneratedColumnSubStrFunc
implements ObGeneratedColumnSimpleFunc {
    private List<String> refColumnNames = new ArrayList<String>();
    private int pos = 0;
    private int len = Integer.MIN_VALUE;

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    @Override
    public void setParameters(List<Object> parameters) throws IllegalArgumentException {
        Object parameter1 = parameters.get(0);
        if (!(parameter1 instanceof String)) {
            throw new IllegalArgumentException("substr first argument must be column or string " + parameter1);
        }
        String ref = (String)parameters.get(0);
        this.refColumnNames.add(ref);
        Object parameter2 = parameters.get(1);
        if (!(parameter2 instanceof Long) && !(parameter2 instanceof Integer)) {
            throw new IllegalArgumentException("substr second argument pos must be int " + parameter2);
        }
        Long pos = ((Number)parameters.get(1)).longValue();
        if (pos == 0L || pos > Integer.MAX_VALUE || pos < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("substr second argument pos must be int exclude zero");
        }
        this.pos = pos.intValue();
        if (parameters.size() == 3) {
            Object parameter3 = parameters.get(2);
            if (!(parameter3 instanceof Long) && !(parameter3 instanceof Integer)) {
                throw new IllegalArgumentException("substr third argument len must be int " + parameter3);
            }
            Long len = ((Number)parameters.get(2)).longValue();
            if (len <= 0L || len > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("substr third argument len must be positive int");
            }
            this.len = len.intValue();
        }
    }

    @Override
    public int getMinParameters() {
        return 2;
    }

    @Override
    public int getMaxParameters() {
        return 3;
    }

    @Override
    public List<String> getRefColumnNames() {
        return this.refColumnNames;
    }

    @Override
    public Object evalValue(ObCollationType collationType, Object ... refs) throws IllegalArgumentException {
        String evalStr;
        if (refs.length != this.refColumnNames.size()) {
            throw new IllegalArgumentException("ObGeneratedColumnSubStrFunc is refer to " + this.refColumnNames + " so that the length of the refs must be equal " + this.refColumnNames.size() + ". refs:" + Arrays.toString(refs));
        }
        Object ref = refs[0];
        if (collationType == ObCollationType.CS_TYPE_BINARY) {
            byte[] evalBytes;
            if (ref instanceof String) {
                evalBytes = ((String)ref).getBytes(Charsets.UTF_8);
            } else if (ref instanceof byte[]) {
                evalBytes = (byte[])ref;
            } else {
                throw new IllegalArgumentException("Object [" + ref + "] can not evaluate by ObGeneratedColumnSubStrFunc with collationType [" + (Object)((Object)collationType) + "]");
            }
            int evalBytesLen = evalBytes.length;
            if (this.pos > 0) {
                if (this.pos > evalBytesLen) {
                    throw new IllegalArgumentException("the length of param :" + evalBytesLen + " is less than the pos " + this.pos);
                }
                if (this.len > 0 && this.pos - 1 + this.len <= evalBytes.length) {
                    byte[] res = new byte[this.len];
                    System.arraycopy(evalBytes, this.pos - 1, res, 0, this.len);
                    return res;
                }
                byte[] res = new byte[evalBytesLen - this.pos + 1];
                System.arraycopy(evalBytes, this.pos - 1, res, 0, evalBytesLen - this.pos + 1);
                return res;
            }
            if (-this.pos > evalBytesLen) {
                throw new IllegalArgumentException("the length of param:" + evalBytesLen + " is less than the pos " + this.pos);
            }
            int pos = evalBytesLen + this.pos;
            if (this.len > 0 && pos + this.len <= evalBytesLen) {
                byte[] res = new byte[this.len];
                System.arraycopy(evalBytes, pos, res, 0, this.len);
                return res;
            }
            byte[] res = new byte[evalBytesLen - pos];
            System.arraycopy(evalBytes, pos, res, 0, evalBytesLen - pos);
            return res;
        }
        if (ref instanceof String) {
            evalStr = (String)ref;
        } else if (ref instanceof byte[]) {
            evalStr = Serialization.decodeVString((byte[])ref);
        } else {
            throw new IllegalArgumentException("Object [" + ref + "] can not evaluate by ObGeneratedColumnSubStrFunc with collationType [" + (Object)((Object)collationType) + "]");
        }
        int evalStrLen = evalStr.length();
        if (this.pos > 0) {
            if (this.pos > evalStrLen) {
                throw new IllegalArgumentException("the length of param :" + evalStrLen + " is less than the pos " + this.pos);
            }
            if (this.len > 0 && this.pos - 1 + this.len <= evalStrLen) {
                return evalStr.substring(this.pos - 1, this.pos - 1 + this.len);
            }
            return evalStr.substring(this.pos - 1);
        }
        if (-this.pos > evalStrLen) {
            throw new IllegalArgumentException("the length of param:" + evalStrLen + " is less than the pos " + this.pos);
        }
        int pos = evalStrLen + this.pos;
        if (this.len > 0 && pos + this.len <= evalStrLen) {
            return evalStr.substring(pos, pos + this.len);
        }
        return evalStr.substring(pos);
    }

    public String toString() {
        return "ObGeneratedColumnSubStrFunc{refColumnNames=" + this.refColumnNames + ", pos=" + this.pos + ", len=" + this.len + '}';
    }
}

