/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.stream.async;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObTableClientQueryAsyncStreamResult
extends AbstractQueryStreamResult {
    private static final Logger logger = LoggerFactory.getLogger(ObTableClientQueryStreamResult.class);
    protected ObTableClient client;
    private boolean isEnd = true;
    private long sessionId;
    private boolean hasMore;

    @Override
    protected ObTableQueryResult execute(ObPair<Long, ObTableParam> partIdWithObTable, ObPayload streamRequest) throws Exception {
        throw new IllegalArgumentException("not support this execute");
    }

    @Override
    protected ObTableQueryAsyncResult executeAsync(ObPair<Long, ObTableParam> partIdWithObTable, ObPayload streamRequest) throws Exception {
        ObPayload result;
        ObTable subObTable = partIdWithObTable.getRight().getObTable();
        boolean needRefreshTableEntry = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        while (true) {
            this.client.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > this.client.getRuntimeMaxWait()) {
                throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "/ms which exceeds response timeout " + this.client.getRuntimeMaxWait() + "/ms");
            }
            ++tryTimes;
            try {
                if (needRefreshTableEntry) {
                    subObTable = this.client.getTable(this.indexTableName, new Long[]{partIdWithObTable.getLeft()}, true, this.client.isTableEntryRefreshIntervalWait()).getRight().getObTable();
                }
                result = subObTable.execute(streamRequest);
                this.client.resetExecuteContinuousFailureCount(this.indexTableName);
            }
            catch (Exception e) {
                if (e instanceof ObTableException && ((ObTableException)e).isNeedRefreshTableEntry()) {
                    needRefreshTableEntry = true;
                    logger.warn("stream query refresh table while meet ObTableMasterChangeException, errorCode: {}", (Object)((ObTableException)e).getErrorCode());
                    if (!this.client.isRetryOnChangeMasterTimes() || tryTimes - 1 >= this.client.getRuntimeRetryTimes()) {
                        this.client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                        throw e;
                    }
                } else {
                    this.client.calculateContinuousFailure(this.indexTableName, e.getMessage());
                    throw e;
                }
                logger.warn("stream query retry while meet ObTableMasterChangeException, errorCode: {} , retry times {}", (Object)((ObTableException)e).getErrorCode(), (Object)tryTimes);
                Thread.sleep(this.client.getRuntimeRetryInterval());
                continue;
            }
            break;
        }
        this.cacheStreamNext(partIdWithObTable, this.checkObTableQueryAsyncResult(result));
        ObTableQueryAsyncResult obTableQueryAsyncResult = (ObTableQueryAsyncResult)result;
        this.isEnd = obTableQueryAsyncResult.isEnd();
        this.sessionId = obTableQueryAsyncResult.getSessionId();
        return (ObTableQueryAsyncResult)result;
    }

    public ObTableClient getClient() {
        return this.client;
    }

    public void setClient(ObTableClient client) {
        this.client = client;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean end) {
        this.isEnd = end;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }
}

