/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.checkandmutate.CheckAndInsUp;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionConsistentException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOpRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.table.AbstractTableBatchOps;
import com.alipay.oceanbase.rpc.table.ConcurrentTask;
import com.alipay.oceanbase.rpc.table.ConcurrentTaskExecutor;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableClientBatchOpsImpl;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.threadlocal.ThreadLocalMap;
import com.alipay.oceanbase.rpc.util.MonitorUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ObTableClientLSBatchOpsImpl
extends AbstractTableBatchOps {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableClientBatchOpsImpl.class);
    private final ObTableClient obTableClient;
    private ExecutorService executorService;
    private boolean returningAffectedEntity = false;
    private List<ObTableSingleOp> batchOperation;

    public ObTableClientLSBatchOpsImpl(String tableName, ObTableClient obTableClient) {
        this.tableName = tableName;
        this.obTableClient = obTableClient;
        this.executorService = obTableClient.getRuntimeBatchExecutor();
        this.batchOperation = new ArrayList<ObTableSingleOp>();
    }

    @Override
    public ObTableBatchOperation getObTableBatchOperation() {
        return null;
    }

    public List<ObTableSingleOp> getSingleOperations() {
        return this.batchOperation;
    }

    @Override
    public void get(Object[] rowkeys, String[] columns) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void update(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void delete(Object[] rowkeys) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void insert(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void replace(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void insertOrUpdate(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void increment(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void append(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        throw new FeatureNotSupportedException();
    }

    private void addOperation(ObTableSingleOp singleOp) {
        this.batchOperation.add(singleOp);
    }

    public void addOperation(CheckAndInsUp checkAndInsUp) {
        InsertOrUpdate insUp = checkAndInsUp.getInsUp();
        ObTableSingleOpQuery query = new ObTableSingleOpQuery();
        ObNewRange range = new ObNewRange();
        range.setStartKey(ObRowKey.getInstance(insUp.getRowKey()));
        range.setEndKey(ObRowKey.getInstance(insUp.getRowKey()));
        query.addScanRangeColumns(insUp.getRowKeyNames());
        query.addScanRange(range);
        query.setFilterString(checkAndInsUp.getFilter().toString());
        String[] rowKeyNames = checkAndInsUp.getInsUp().getRowKeyNames().toArray(new String[0]);
        Object[] rowKey = checkAndInsUp.getInsUp().getRowKey();
        String[] propertiesNames = checkAndInsUp.getInsUp().getColumns();
        Object[] propertiesValues = checkAndInsUp.getInsUp().getValues();
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKey, propertiesNames, propertiesValues);
        ObTableSingleOp singleOp = new ObTableSingleOp();
        singleOp.setSingleOpType(ObTableOperationType.CHECK_AND_INSERT_UP);
        singleOp.setIsCheckNoExists(!checkAndInsUp.isCheckExists());
        singleOp.setQuery(query);
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    @Override
    public List<Object> execute() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.size());
        for (ObTableSingleOpResult result : this.executeInternal().getResults()) {
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                results.add(result.getAffectedRows());
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    @Override
    public List<Object> executeWithResult() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.size());
        for (ObTableSingleOpResult result : this.executeInternal().getResults()) {
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                results.add(new MutationResult(result));
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    public Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> partitionPrepare() throws Exception {
        List<ObTableSingleOp> operations = this.getSingleOperations();
        HashMap<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> partitionOperationsMap = new HashMap<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>();
        if (this.obTableClient.isOdpMode()) {
            ObPair obTableOperations = new ObPair(new ObTableParam(this.obTableClient.getOdpTable()), new ArrayList());
            for (int i = 0; i < operations.size(); ++i) {
                ObTableSingleOp operation = operations.get(i);
                ((List)obTableOperations.getRight()).add(new ObPair<Integer, ObTableSingleOp>(i, operation));
            }
            partitionOperationsMap.put(0L, obTableOperations);
            return partitionOperationsMap;
        }
        for (int i = 0; i < operations.size(); ++i) {
            ObTableSingleOp operation = operations.get(i);
            ObRowKey rowKeyObject = operation.getScanRange().get(0).getStartKey();
            int rowKeySize = rowKeyObject.getObjs().size();
            Object[] rowKey = new Object[rowKeySize];
            for (int j = 0; j < rowKeySize; ++j) {
                rowKey[j] = rowKeyObject.getObj(j).getValue();
            }
            ObPair<Long, ObTableParam> tableObPair = this.obTableClient.getTable(this.tableName, rowKey, false, false, this.obTableClient.getRoute(false));
            ObPair obTableOperations = (ObPair)partitionOperationsMap.get(tableObPair.getLeft());
            if (obTableOperations == null) {
                obTableOperations = new ObPair(tableObPair.getRight(), new ArrayList());
                partitionOperationsMap.put(tableObPair.getLeft(), obTableOperations);
            }
            ((List)obTableOperations.getRight()).add(new ObPair<Integer, ObTableSingleOp>(i, operation));
        }
        if (this.atomicOperation && partitionOperationsMap.size() > 1) {
            throw new ObTablePartitionConsistentException("require atomic operation but found across partition may cause consistent problem ");
        }
        return partitionOperationsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partitionExecute(ObTableSingleOpResult[] results, Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> partitionOperation) throws Exception {
        List<ObTableSingleOpResult> subObTableSingleOpResults;
        long endExecute;
        long startExecute;
        ObTableTabletOp tabletOp;
        ObTableLSOpRequest subRequest;
        ObTable subObTable;
        block29: {
            ObTableLSOpResult subLSOpResult;
            ObTableParam tableParam = partitionOperation.getValue().getLeft();
            long tableId = tableParam.getTableId();
            long partId = tableParam.getPartitionId();
            long originPartId = tableParam.getPartId();
            subObTable = tableParam.getObTable();
            List<ObPair<Integer, ObTableSingleOp>> subOperationWithIndexList = partitionOperation.getValue().getRight();
            subRequest = new ObTableLSOpRequest();
            ArrayList<ObTableSingleOp> subOperations = new ArrayList<ObTableSingleOp>();
            for (ObPair<Integer, ObTableSingleOp> operationWithIndex : subOperationWithIndexList) {
                subOperations.add(operationWithIndex.getRight());
            }
            tabletOp = new ObTableTabletOp();
            tabletOp.setSingleOperations(subOperations);
            tabletOp.setTabletId(partId);
            ObTableLSOperation lsOperation = new ObTableLSOperation();
            lsOperation.addTabletOperation(tabletOp);
            lsOperation.prepare();
            subRequest.setLsOperation(lsOperation);
            subRequest.setTableId(tableId);
            subRequest.setEntityType(this.entityType);
            subRequest.setTimeout(subObTable.getObTableOperationTimeout());
            boolean needRefreshTableEntry = false;
            int tryTimes = 0;
            startExecute = System.currentTimeMillis();
            HashSet<String> failedServerList = null;
            ObServerRoute route = null;
            while (true) {
                this.obTableClient.checkStatus();
                long currentExecute = System.currentTimeMillis();
                long costMillis = currentExecute - startExecute;
                if (costMillis > this.obTableClient.getRuntimeMaxWait()) {
                    logger.error("table name: {} partition id:{} it has tried " + tryTimes + " times and it has waited " + costMillis + " ms which exceeds runtime max wait timeout " + this.obTableClient.getRuntimeMaxWait() + " ms", (Object)this.tableName, (Object)partId);
                    throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "ms which exceeds runtime max wait timeout " + this.obTableClient.getRuntimeMaxWait() + "ms");
                }
                ++tryTimes;
                try {
                    if (this.obTableClient.isOdpMode()) {
                        subObTable = this.obTableClient.getOdpTable();
                    } else if (tryTimes > 1) {
                        if (route == null) {
                            route = this.obTableClient.getRoute(false);
                        }
                        if (failedServerList != null) {
                            route.setBlackList(failedServerList);
                        }
                        subObTable = this.obTableClient.getTable(this.tableName, originPartId, needRefreshTableEntry, this.obTableClient.isTableEntryRefreshIntervalWait(), route).getRight().getObTable();
                    }
                    subLSOpResult = (ObTableLSOpResult)subObTable.execute(subRequest);
                    this.obTableClient.resetExecuteContinuousFailureCount(this.tableName);
                }
                catch (Exception ex) {
                    block28: {
                        if (this.obTableClient.isOdpMode()) {
                            if (tryTimes - 1 >= this.obTableClient.getRuntimeRetryTimes()) {
                                throw ex;
                            }
                            logger.warn("batch ops execute while meet Exception, tablename:{}, errorCode: {} , errorMsg: {}, try times {}", new Object[]{this.tableName, ((ObTableException)ex).getErrorCode(), ex.getMessage(), tryTimes});
                        } else if (ex instanceof ObTableReplicaNotReadableException) {
                            if (tryTimes - 1 >= this.obTableClient.getRuntimeRetryTimes()) {
                                logger.warn("exhaust retry when replica not readable: {}", (Object)ex.getMessage());
                                throw ex;
                            }
                            logger.warn("tablename:{} partition id:{} retry when replica not readable: {}", new Object[]{this.tableName, partId, ex.getMessage()});
                            if (failedServerList == null) {
                                failedServerList = new HashSet<String>();
                            }
                            failedServerList.add(subObTable.getIp());
                        } else {
                            if (ex instanceof ObTableException && ((ObTableException)ex).isNeedRefreshTableEntry()) {
                                needRefreshTableEntry = true;
                                logger.warn("tablename:{} partition id:{} batch ops refresh table while meet ObTableMasterChangeException, errorCode: {}", new Object[]{this.tableName, partId, ((ObTableException)ex).getErrorCode(), ex});
                                if (this.obTableClient.isRetryOnChangeMasterTimes() && tryTimes - 1 < this.obTableClient.getRuntimeRetryTimes()) {
                                    logger.warn("tablename:{} partition id:{} batch ops retry while meet ObTableMasterChangeException, errorCode: {} , retry times {}", new Object[]{this.tableName, partId, ((ObTableException)ex).getErrorCode(), tryTimes, ex});
                                    break block28;
                                } else {
                                    this.obTableClient.calculateContinuousFailure(this.tableName, ex.getMessage());
                                    throw ex;
                                }
                            }
                            this.obTableClient.calculateContinuousFailure(this.tableName, ex.getMessage());
                            throw ex;
                        }
                    }
                    Thread.sleep(this.obTableClient.getRuntimeRetryInterval());
                    continue;
                }
                break;
            }
            endExecute = System.currentTimeMillis();
            if (subLSOpResult == null) {
                TableClientLoggerFactory.RUNTIME.error("tablename:{} partition id:{} check batch operation result error: client get unexpected NULL result", (Object)this.tableName, (Object)partId);
                throw new ObTableUnexpectedException("check batch operation result error: client get unexpected NULL result");
            }
            List<ObTableTabletOpResult> tabletOpResults = subLSOpResult.getResults();
            if (tabletOpResults.size() != 1) {
                throw new ObTableUnexpectedException("check batch result error: partition " + partId + " expect tablet op result size 1 actual result size is " + tabletOpResults.size());
            }
            subObTableSingleOpResults = tabletOpResults.get(0).getResults();
            if (subObTableSingleOpResults.size() < subOperations.size()) {
                if (subObTableSingleOpResults.size() == 1 && this.entityType == ObTableEntityType.HKV) {
                    ObTableSingleOpResult subObTableSingleOpResult = subObTableSingleOpResults.get(0);
                    subObTableSingleOpResult.setExecuteHost(subObTable.getIp());
                    subObTableSingleOpResult.setExecutePort(subObTable.getPort());
                    for (ObPair<Integer, ObTableSingleOp> SubOperationWithIndexList : subOperationWithIndexList) {
                        results[SubOperationWithIndexList.getLeft().intValue()] = subObTableSingleOpResult;
                    }
                    break block29;
                } else {
                    throw new IllegalArgumentException("check batch operation result size error: operation size [" + subOperations.size() + "] result size [" + subObTableSingleOpResults.size() + "]");
                }
            }
            if (subOperationWithIndexList.size() != subObTableSingleOpResults.size()) {
                throw new ObTableUnexpectedException("check batch result error: partition " + partId + " expect result size " + subOperationWithIndexList.size() + " actual result size " + subObTableSingleOpResults.size());
            }
            for (int i = 0; i < subOperationWithIndexList.size(); ++i) {
                ObTableSingleOpResult subObTableSingleOpResult = subObTableSingleOpResults.get(i);
                subObTableSingleOpResult.setExecuteHost(subObTable.getIp());
                subObTableSingleOpResult.setExecutePort(subObTable.getPort());
                results[subOperationWithIndexList.get((int)i).getLeft().intValue()] = subObTableSingleOpResult;
            }
        }
        String endpoint = subObTable.getIp() + ":" + subObTable.getPort();
        MonitorUtil.info((ObPayload)subRequest, subObTable.getDatabase(), this.tableName, "BATCH-partitionExecute-", endpoint, tabletOp, subObTableSingleOpResults.size(), endExecute - startExecute, this.obTableClient.getslowQueryMonitorThreshold());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObTableTabletOpResult executeInternal() throws Exception {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        long start = System.currentTimeMillis();
        final ObTableSingleOpResult[] obTableOperationResults = new ObTableSingleOpResult[this.batchOperation.size()];
        Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> partitions = this.partitionPrepare();
        long getTableTime = System.currentTimeMillis();
        final Map<Object, Object> context = ThreadLocalMap.getContextMap();
        if (this.executorService != null && !this.executorService.isShutdown() && partitions.size() > 1) {
            final ConcurrentTaskExecutor executor = new ConcurrentTaskExecutor(this.executorService, partitions.size());
            for (final Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> entry : partitions.entrySet()) {
                executor.execute(new ConcurrentTask(){

                    @Override
                    public void doTask() {
                        try {
                            ThreadLocalMap.transmitContextMap(context);
                            ObTableClientLSBatchOpsImpl.this.partitionExecute(obTableOperationResults, entry);
                        }
                        catch (Exception e) {
                            logger.error(TableClientLoggerFactory.LCD.convert("01-00026"), (Throwable)e);
                            executor.collectExceptions(e);
                        }
                        finally {
                            ThreadLocalMap.reset();
                        }
                    }
                });
            }
            long timeoutTs = this.obTableClient.getRuntimeBatchMaxWait() * 1000L * 1000L + System.nanoTime();
            try {
                while (timeoutTs > System.nanoTime()) {
                    try {
                        executor.waitComplete(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute interrupted", e);
                    }
                    if (executor.getThrowableList().size() > 0) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
                    }
                    if (!executor.isComplete()) continue;
                    break;
                }
            }
            finally {
                executor.stop();
            }
            if (executor.getThrowableList().size() > 0) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
            }
            if (!executor.isComplete()) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error, runtimeBatchMaxWait: " + this.obTableClient.getRuntimeBatchMaxWait() + "ms");
            }
        } else {
            for (Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> entry : partitions.entrySet()) {
                this.partitionExecute(obTableOperationResults, entry);
            }
        }
        ObTableTabletOpResult batchOperationResult = new ObTableTabletOpResult();
        for (ObTableSingleOpResult obTableOperationResult : obTableOperationResults) {
            batchOperationResult.addResult(obTableOperationResult);
        }
        MonitorUtil.info((ObPayload)batchOperationResult, this.obTableClient.getDatabase(), this.tableName, "BATCH", "", obTableOperationResults.length, getTableTime - start, System.currentTimeMillis() - getTableTime, this.obTableClient.getslowQueryMonitorThreshold());
        return batchOperationResult;
    }

    @Override
    public void clear() {
        this.batchOperation = new ArrayList<ObTableSingleOp>();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isReturningAffectedEntity() {
        return this.returningAffectedEntity;
    }

    public void setReturningAffectedEntity(boolean returningAffectedEntity) {
        this.returningAffectedEntity = returningAffectedEntity;
    }
}

