/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.threadlocal;

import com.alipay.oceanbase.rpc.location.model.ObReadConsistency;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class ThreadLocalMap {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ThreadLocalMap.class);
    private static final ThreadLocal<Map<Object, Object>> THREAD_LOCAL_CONTEXT = new MapThreadLocal();
    public static final String PROCESS_PRIORITY = "PROCESS_PRIORITY";
    public static final String READ_CONSISTENCY = "READ_CONSISTENCY";

    public static void setProcessHighPriority() {
        ThreadLocalMap.getContextMap().put(PROCESS_PRIORITY, (short)4);
    }

    public static void setProcessNormalPriority() {
        ThreadLocalMap.getContextMap().put(PROCESS_PRIORITY, (short)5);
    }

    public static void setProcessLowPriority() {
        ThreadLocalMap.getContextMap().put(PROCESS_PRIORITY, (short)6);
    }

    public static short getProcessPriority() {
        if (ThreadLocalMap.getContextMap() == null || ThreadLocalMap.getContextMap().get(PROCESS_PRIORITY) == null) {
            return 5;
        }
        return (Short)ThreadLocalMap.getContextMap().get(PROCESS_PRIORITY);
    }

    public static void setReadConsistency(ObReadConsistency readConsistency) {
        ThreadLocalMap.getContextMap().put(READ_CONSISTENCY, (Object)readConsistency);
    }

    public static ObReadConsistency getReadConsistency() {
        return (ObReadConsistency)((Object)ThreadLocalMap.getContextMap().get(READ_CONSISTENCY));
    }

    public static void clearReadConsistency() {
        if (ThreadLocalMap.getContextMap().containsKey(READ_CONSISTENCY)) {
            ThreadLocalMap.getContextMap().remove(READ_CONSISTENCY);
        }
    }

    public static Map<Object, Object> getContextMap() {
        return THREAD_LOCAL_CONTEXT.get();
    }

    public static void setContextMap(Map<Object, Object> context) {
        THREAD_LOCAL_CONTEXT.set(context);
    }

    public static void transmitContextMap(Map<Object, Object> context) {
        for (Map.Entry<Object, Object> entry : context.entrySet()) {
            ThreadLocalMap.getContextMap().put(entry.getKey(), entry.getValue());
        }
    }

    public static void reset() {
        ThreadLocalMap.getContextMap().clear();
    }

    private static class MapThreadLocal
    extends ThreadLocal<Map<Object, Object>> {
        private MapThreadLocal() {
        }

        @Override
        protected Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>(){
                private static final long serialVersionUID = 3637958959138295593L;

                @Override
                public Object put(Object key, Object value) {
                    if (logger.isDebugEnabled()) {
                        if (this.containsKey(key)) {
                            logger.debug("Overwritten attribute to thread context: " + key + " = " + value);
                        } else {
                            logger.debug("Added attribute to thread context: " + key + " = " + value);
                        }
                    }
                    return super.put(key, value);
                }
            };
        }
    }
}

