/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alibaba.fastjson.JSON;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObITableEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.oceanbase.rpc.util.ObVString;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import com.alipay.oceanbase.rpc.util.TraceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MonitorUtil {
    private static String buildParamsString(List<Object> rowKeys) {
        if (rowKeys == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object value : rowKeys) {
            StringBuilder sb;
            String str;
            if (value instanceof byte[]) {
                value = new String((byte[])value);
            }
            if (value instanceof ObVString) {
                value = ((ObVString)value).getStringVal();
            }
            if ((str = (sb = new StringBuilder()).append(JSON.toJSON((Object)value)).toString()).length() > 10) {
                str = str.substring(0, 10);
            }
            stringBuilder.append(str).append("#");
        }
        return stringBuilder.toString();
    }

    private static String logMessage(String traceId, String database, String tableName, String methodName, String type, String endpoint, List<Object> params, ObTableQueryAndMutateResult result, long routeTableTime, long executeTime) {
        if (StringUtils.isNotBlank((String)endpoint)) {
            endpoint = endpoint.replaceAll(",", "#");
        }
        String argsValue = MonitorUtil.buildParamsString(params);
        String res = String.valueOf(result.getAffectedRows());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(traceId).append(" - ").append(database).append(",").append(tableName).append(",").append(methodName).append(",").append(type).append(",").append(endpoint).append(",").append(argsValue).append(",").append(res).append(",").append(routeTableTime).append(",").append(executeTime).append(",").append(executeTime + routeTableTime);
        return stringBuilder.toString();
    }

    public static void info(ObPayload payload, String database, String tableName, String methodName, String type, String endpoint, ObTableQueryAndMutateResult result, ObTableQuery tableQuery, long routeTableTime, long executeTime, long slowQueryMonitorThreshold) {
        if (routeTableTime + executeTime >= slowQueryMonitorThreshold) {
            ArrayList<Object> params = new ArrayList<Object>();
            for (ObNewRange rang : tableQuery.getKeyRanges()) {
                int i;
                ObRowKey startKey = rang.getStartKey();
                int startKeySize = startKey.getObjs().size();
                ObRowKey endKey = rang.getEndKey();
                int endKeySize = endKey.getObjs().size();
                for (i = 0; i < startKeySize; ++i) {
                    params.add(startKey.getObj(i).getValue());
                }
                for (i = 0; i < endKeySize; ++i) {
                    params.add(endKey.getObj(i).getValue());
                }
            }
            TableClientLoggerFactory.MONITOR.info(MonitorUtil.logMessage(TraceUtil.formatTraceMessage(payload), database, tableName, methodName, type, endpoint, params, result, routeTableTime, executeTime));
        }
    }

    private static String logMessage(String traceId, String database, String tableName, String methodName, String endpoint, Object[] rowKeys, ObTableOperationResult result, long routeTableTime, long executeTime) {
        if (StringUtils.isNotBlank((String)endpoint)) {
            endpoint = endpoint.replaceAll(",", "#");
        }
        String argsValue = rowKeys == null || rowKeys.length == 0 ? "rowKeys:null" : MonitorUtil.buildParamsString(Arrays.asList(rowKeys));
        ResultCodes resultCode = ResultCodes.valueOf(result.getHeader().getErrno());
        String res = "";
        if (resultCode == ResultCodes.OB_SUCCESS) {
            switch (result.getOperationType()) {
                case GET: 
                case INCREMENT: 
                case APPEND: {
                    res = String.valueOf(result.getEntity().getSimpleProperties().size());
                    break;
                }
                default: {
                    res = String.valueOf(result.getAffectedRows());
                }
            }
        }
        String errorCodeStringValue = "UnknownErrorCode";
        if (resultCode != null) {
            errorCodeStringValue = resultCode.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(traceId).append(" - ").append(database).append(",").append(tableName).append(",").append(methodName).append(",").append(endpoint).append(",").append(argsValue).append(",").append(errorCodeStringValue).append(",").append(res).append(",").append(routeTableTime).append(",").append(executeTime).append(",").append(executeTime + routeTableTime);
        return stringBuilder.toString();
    }

    public static void info(ObPayload payload, String database, String tableName, String methodName, String endpoint, Object[] rowKeys, ObTableOperationResult result, long routeTableTime, long executeTime, long slowQueryMonitorThreshold) {
        if (routeTableTime + executeTime >= slowQueryMonitorThreshold) {
            TableClientLoggerFactory.MONITOR.info(MonitorUtil.logMessage(TraceUtil.formatTraceMessage(payload), database, tableName, methodName, endpoint, rowKeys, result, routeTableTime, executeTime));
        }
    }

    private static String logMessage(String traceId, String database, String tableName, String methodName, String endpoint, List<Object> rowKeys, int resultSize, long executeTime) {
        if (StringUtils.isNotBlank((String)endpoint)) {
            endpoint = endpoint.replaceAll(",", "#");
        }
        String argsValue = rowKeys == null || rowKeys.isEmpty() ? "rowKeys:null" : MonitorUtil.buildParamsString(rowKeys);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(traceId).append(" - ").append(database).append(",").append(tableName).append(",").append(methodName).append(",").append(endpoint).append(",").append(argsValue).append(",").append(resultSize).append(",").append(0).append(",").append(executeTime).append(",").append(executeTime);
        return stringBuilder.toString();
    }

    private static void logMessage0(ObPayload payload, String database, String tableName, String methodName, String endpoint, ObTableBatchOperation subOperations, long partId, int resultSize, long executeTime, long slowQueryMonitorThreshold) {
        if (executeTime < slowQueryMonitorThreshold) {
            return;
        }
        String traceId = TraceUtil.formatTraceMessage(payload);
        List<ObTableOperation> ops = subOperations.getTableOperations();
        for (ObTableOperation op : ops) {
            ArrayList<Object> rowKeys = new ArrayList<Object>();
            ObTableOperationType type = op.getOperationType();
            ObITableEntity entity = op.getEntity();
            if (entity != null) {
                long rowkeySize = entity.getRowKeySize();
                ObRowKey rowKey = entity.getRowKey();
                if (rowKey != null && rowkeySize != 0L) {
                    int i = 0;
                    while ((long)i < rowkeySize) {
                        ObObj obObj = entity.getRowKeyValue(i);
                        if (obObj != null) {
                            rowKeys.add(obObj.getValue());
                        }
                        ++i;
                    }
                }
            }
            TableClientLoggerFactory.MONITOR.info(MonitorUtil.logMessage(traceId, database, tableName, methodName + (Object)((Object)type) + "-" + partId, endpoint, rowKeys, resultSize, executeTime));
        }
    }

    private static String logMessage(String traceId, String database, String tableName, String methodName, String endpoint, int resultSize, long routeTableTime, long executeTime) {
        if (StringUtils.isNotBlank((String)endpoint)) {
            endpoint = endpoint.replaceAll(",", "#");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(traceId).append(" - ").append(database).append(",").append(tableName).append(",").append(methodName).append(",").append(endpoint).append(",").append(",").append(resultSize).append(",").append(routeTableTime).append(",").append(executeTime).append(",").append(routeTableTime + executeTime);
        return stringBuilder.toString();
    }

    public static void info(ObPayload payload, String database, String tableName, String methodName, String endpoint, ObTableBatchOperation subOperations, long partId, int resultSize, long executeTime, long slowQueryMonitorThreshold) {
        MonitorUtil.logMessage0(payload, database, tableName, methodName, endpoint, subOperations, partId, resultSize, executeTime, slowQueryMonitorThreshold);
    }

    public static void info(ObPayload payload, String database, String tableName, String methodName, String endpoint, int resultSize, long routeTableTime, long executeTime, long slowQueryMonitorThreshold) {
        if (routeTableTime + executeTime >= slowQueryMonitorThreshold) {
            TableClientLoggerFactory.MONITOR.info(MonitorUtil.logMessage(TraceUtil.formatTraceMessage(payload), database, tableName, methodName, endpoint, resultSize, routeTableTime, executeTime));
        }
    }

    private static String logMessage(String traceId, String database, String tableName, String methodName, String endpoint, List<Object> params, ObTableClientQueryStreamResult result, long routeTableTime, long executeTime) {
        if (StringUtils.isNotBlank((String)endpoint)) {
            endpoint = endpoint.replaceAll(",", "#");
        }
        String argsValue = MonitorUtil.buildParamsString(params);
        String res = String.valueOf(result.getCacheRows().size());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(traceId).append(",").append(database).append(",").append(tableName).append(",").append(methodName).append(",").append(endpoint).append(",").append(argsValue).append(",").append(res).append(",").append(routeTableTime).append(",").append(executeTime).append(",").append(routeTableTime + executeTime);
        return stringBuilder.toString();
    }

    public static void info(ObPayload payload, String database, String tableName, String methodName, String endpoint, ObTableQuery tableQuery, ObTableClientQueryStreamResult result, long routeTableTime, long executeTime, long slowQueryMonitorThreshold) {
        if (routeTableTime + executeTime >= slowQueryMonitorThreshold) {
            ArrayList<Object> params = new ArrayList<Object>();
            for (ObNewRange rang : tableQuery.getKeyRanges()) {
                int i;
                ObRowKey startKey = rang.getStartKey();
                int startKeySize = startKey.getObjs().size();
                ObRowKey endKey = rang.getEndKey();
                int endKeySize = endKey.getObjs().size();
                for (i = 0; i < startKeySize; ++i) {
                    params.add(startKey.getObj(i).getValue());
                }
                for (i = 0; i < endKeySize; ++i) {
                    params.add(endKey.getObj(i).getValue());
                }
            }
            TableClientLoggerFactory.MONITOR.info(MonitorUtil.logMessage(TraceUtil.formatTraceMessage(payload), database, tableName, methodName, endpoint, params, result, routeTableTime, executeTime));
        }
    }

    private static void logTabletOpMessage(ObPayload payload, String database, String tableName, String methodName, String endpoint, ObTableTabletOp tabletOp, int resultSize, long executeTime, long slowQueryMonitorThreshold) {
        if (executeTime < slowQueryMonitorThreshold) {
            return;
        }
        String traceId = TraceUtil.formatTraceMessage(payload);
        TableClientLoggerFactory.MONITOR.info(MonitorUtil.logMessage(traceId, database, tableName, methodName + "-" + tabletOp.getTabletId(), endpoint, null, resultSize, executeTime));
    }

    public static void info(ObPayload payload, String database, String tableName, String methodName, String endpoint, ObTableTabletOp tabletOp, int resultSize, long executeTime, long slowQueryMonitorThreshold) {
        MonitorUtil.logTabletOpMessage(payload, database, tableName, methodName, endpoint, tabletOp, resultSize, executeTime, slowQueryMonitorThreshold);
    }
}

