/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

public class ObByteBuf {
    public byte[] bytes;
    public int pos;

    public ObByteBuf(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException(String.format("invalid args, capacity(%d)", capacity));
        }
        this.bytes = new byte[capacity];
        this.pos = 0;
    }

    public ObByteBuf(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("invalid args, bytes(null)", new Object[0]));
        }
        this.bytes = bytes;
        this.pos = 0;
    }

    public int capacity() {
        return this.bytes.length;
    }

    public void writeByte(byte b) {
        if (this.pos + 1 > this.bytes.length) {
            throw new IllegalArgumentException(String.format("size overflow, capacity(%d), pos(%d), data_size(1)", this.bytes.length, this.pos));
        }
        this.bytes[this.pos++] = b;
    }

    public void writeBytes(byte[] src) {
        if (this.pos + src.length > this.bytes.length) {
            throw new IllegalArgumentException(String.format("size overflow, capacity(%d), pos(%d), data_size(%d)", this.bytes.length, this.pos, src.length));
        }
        System.arraycopy(src, 0, this.bytes, this.pos, src.length);
        this.pos += src.length;
    }

    public void writeBytes(byte[] src, int srcPos, int srcLength) {
        if (this.pos + srcLength > this.bytes.length) {
            throw new IllegalArgumentException(String.format("size overflow, capacity(%d), pos(%d), data_size(%d)", this.bytes.length, this.pos, srcLength));
        }
        System.arraycopy(src, srcPos, this.bytes, this.pos, srcLength);
        this.pos += srcLength;
    }
}

