/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc;

import com.alipay.oceanbase.rpc.location.model.partition.Partition;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObHTableFilter;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryAsyncStreamResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.table.AbstractTableQuery;
import com.alipay.oceanbase.rpc.table.ObTableClientQueryImpl;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.List;

public class ObClusterTableQuery
extends AbstractTableQuery {
    private final ObTableClientQueryImpl tableClientQuery;

    public ObClusterTableQuery(ObTableClientQueryImpl tableQuery) {
        this.tableClientQuery = tableQuery;
    }

    public void addAggregation(ObTableAggregationType aggType, String aggColumn) {
        this.tableClientQuery.addAggregation(aggType, aggColumn);
    }

    @Override
    public String getTableName() {
        return this.tableClientQuery.getTableName();
    }

    @Override
    public ObTableQuery getObTableQuery() {
        return this.tableClientQuery.getObTableQuery();
    }

    @Override
    public List<String> getSelectColumns() {
        return this.tableClientQuery.getSelectColumns();
    }

    @Override
    public Row getRowKey() {
        return this.tableClientQuery.getRowKey();
    }

    @Override
    public QueryResultSet execute() throws Exception {
        return this.tableClientQuery.execute();
    }

    @Override
    public QueryResultSet asyncExecute() throws Exception {
        return this.tableClientQuery.asyncExecute();
    }

    public ObTableClientQueryStreamResult executeInternal() throws Exception {
        return this.tableClientQuery.executeInternal();
    }

    public ObTableClientQueryAsyncStreamResult asyncExecuteInternal() throws Exception {
        return this.tableClientQuery.asyncExecuteInternal();
    }

    @Override
    public TableQuery select(String ... columns) {
        this.tableClientQuery.select(columns);
        return this;
    }

    @Override
    public TableQuery setKeys(String ... keys) {
        throw new IllegalArgumentException("Not needed");
    }

    @Override
    public TableQuery setRowKey(Row row) throws Exception {
        this.tableClientQuery.setRowKey(row);
        return this;
    }

    @Override
    public TableQuery limit(int offset, int limit) {
        this.tableClientQuery.limit(offset, limit);
        return this;
    }

    @Override
    public TableQuery addScanRange(Object[] start, boolean startEquals, Object[] end, boolean endEquals) {
        this.tableClientQuery.addScanRange(start, startEquals, end, endEquals);
        return this;
    }

    @Override
    public TableQuery addScanRange(Object start, Object end) {
        if (start instanceof Partition) {
            Long endPartId;
            Long endPartitionId;
            Long startPartitionId = ((Partition)start).getPartitionId();
            if (!startPartitionId.equals(endPartitionId = ((Partition)end).getPartitionId())) {
                throw new IllegalArgumentException("The partition id must be the same for start and end partition in scan range");
            }
            Long startPartId = ((Partition)start).getPartId();
            if (!startPartId.equals(endPartId = ((Partition)end).getPartId())) {
                throw new IllegalArgumentException("The logic part id must be the same for start and end partition in scan range");
            }
            this.tableClientQuery.setPartId(startPartId);
            start = ObObj.getMin();
            end = ObObj.getMax();
        }
        return this.addScanRange(new Object[]{start}, true, new Object[]{end}, true);
    }

    @Override
    public TableQuery addScanRangeStartsWith(Object[] start, boolean startEquals) {
        this.tableClientQuery.addScanRangeStartsWith(start, startEquals);
        return this;
    }

    @Override
    public TableQuery addScanRangeEndsWith(Object[] end, boolean endEquals) {
        this.tableClientQuery.addScanRangeEndsWith(end, endEquals);
        return this;
    }

    @Override
    public TableQuery scanOrder(boolean forward) {
        this.tableClientQuery.scanOrder(forward);
        return this;
    }

    @Override
    public TableQuery indexName(String indexName) {
        this.tableClientQuery.indexName(indexName);
        return this;
    }

    @Override
    public TableQuery filterString(String filterString) {
        this.tableClientQuery.filterString(filterString);
        return this;
    }

    @Override
    public TableQuery setHTableFilter(ObHTableFilter obHTableFilter) {
        return this.tableClientQuery.setHTableFilter(obHTableFilter);
    }

    @Override
    public TableQuery setBatchSize(int batchSize) {
        return this.tableClientQuery.setBatchSize(batchSize);
    }

    @Override
    public TableQuery setMaxResultSize(long maxResultSize) {
        return this.tableClientQuery.setMaxResultSize(maxResultSize);
    }

    @Override
    public TableQuery setOperationTimeout(long operationTimeout) {
        this.tableClientQuery.setOperationTimeout(operationTimeout);
        return this;
    }

    @Override
    public void clear() {
        this.tableClientQuery.clear();
    }

    @Override
    public void setEntityType(ObTableEntityType entityType) {
        super.setEntityType(entityType);
        this.tableClientQuery.setEntityType(entityType);
    }
}

