/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.protocol;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.oceanbase.rpc.bolt.protocol.ObTableProtocol;
import com.alipay.oceanbase.rpc.util.Serialization;
import com.alipay.remoting.CommandDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;

public class ObTablePacketDecoder
implements CommandDecoder {
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() > 16) {
            in.markReaderIndex();
            byte b = in.readByte();
            if (b != ObTableProtocol.MAGIC_HEADER_FLAG[0]) {
                throw new RuntimeException("magic header wrong, 0 expect: " + ObTableProtocol.MAGIC_HEADER_FLAG[0] + ", but: " + b);
            }
            b = in.readByte();
            if (b != ObTableProtocol.MAGIC_HEADER_FLAG[1]) {
                throw new RuntimeException("magic header wrong, 2 expect: " + ObTableProtocol.MAGIC_HEADER_FLAG[1] + ", but: " + b);
            }
            b = in.readByte();
            if (b != ObTableProtocol.MAGIC_HEADER_FLAG[2]) {
                throw new RuntimeException("magic header wrong, 2 expect: " + ObTableProtocol.MAGIC_HEADER_FLAG[2] + ", but: " + b);
            }
            b = in.readByte();
            if (b != ObTableProtocol.MAGIC_HEADER_FLAG[3]) {
                throw new RuntimeException("magic header wrong, 3 expect: " + ObTableProtocol.MAGIC_HEADER_FLAG[3] + ", but: " + b);
            }
            byte[] dlen = new byte[4];
            in.readBytes(dlen);
            int dataLen = Serialization.decodeI32(dlen);
            byte[] chid = new byte[4];
            in.readBytes(chid);
            int channelId = Serialization.decodeI32(chid);
            in.readByte();
            in.readByte();
            in.readByte();
            in.readByte();
            if (in.readableBytes() >= dataLen) {
                ObTablePacket obCommand = new ObTablePacket();
                obCommand.setId(channelId);
                ByteBuf rpcPacketByteBuf = in.readBytes(dataLen);
                obCommand.setPacketContentBuf(rpcPacketByteBuf);
                out.add(obCommand);
            } else {
                in.resetReaderIndex();
            }
        }
    }
}

