/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.transport;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.RemotingContext;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.util.RemotingUtil;
import io.netty.channel.Channel;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;

public class ObTablePacketProcessor
implements RemotingProcessor<ObTablePacket> {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTablePacketProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RemotingContext ctx, ObTablePacket msg, ExecutorService defaultExecutor) {
        Connection conn = (Connection)ctx.getChannelContext().channel().attr(Connection.CONNECTION).get();
        InvokeFuture future = conn.removeInvokeFuture(msg.getId());
        ClassLoader oldClassLoader = null;
        try {
            if (future != null) {
                if (future.getAppClassLoader() != null) {
                    oldClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(future.getAppClassLoader());
                }
                future.putResponse((RemotingCommand)msg);
                future.cancelTimeout();
                try {
                    future.executeInvokeCallback();
                }
                catch (Exception e) {
                    logger.error(TableClientLoggerFactory.LCD.convert("01-00022"), (Object)msg.getId(), (Object)e);
                }
            } else {
                logger.warn("Cannot find InvokeFuture, maybe already timeout, id={}, from={} ", (Object)msg.getId(), (Object)RemotingUtil.parseRemoteAddress((Channel)ctx.getChannelContext().channel()));
                msg.releaseByteBuf();
            }
        }
        finally {
            if (null != oldClassLoader) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public ExecutorService getExecutor() {
        return null;
    }

    public void setExecutor(ExecutorService executor) {
    }
}

