/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.checkandmutate;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.table.api.Table;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.ArrayList;

public class CheckAndInsUp {
    private Table client;
    private String tableName;
    private ObTableFilter filter;
    private InsertOrUpdate insUp;
    private boolean checkExists = true;
    private boolean rollbackWhenCheckFailed = false;

    public CheckAndInsUp(ObTableFilter filter, InsertOrUpdate insUp, boolean check_exists) throws IllegalArgumentException {
        this(null, null, filter, insUp, check_exists, false);
    }

    public CheckAndInsUp(ObTableFilter filter, InsertOrUpdate insUp, boolean check_exists, boolean rollbackWhenCheckFailed) throws IllegalArgumentException {
        this(null, null, filter, insUp, check_exists, rollbackWhenCheckFailed);
    }

    public CheckAndInsUp(Table client, String tableName, ObTableFilter filter, InsertOrUpdate insUp, boolean check_exists) throws IllegalArgumentException {
        this(client, tableName, filter, insUp, check_exists, false);
    }

    public CheckAndInsUp(Table client, String tableName, ObTableFilter filter, InsertOrUpdate insUp, boolean check_exists, boolean rollbackWhenCheckFailed) throws IllegalArgumentException {
        this.client = client;
        this.tableName = tableName;
        this.filter = filter;
        this.insUp = insUp;
        this.checkExists = check_exists;
        this.rollbackWhenCheckFailed = rollbackWhenCheckFailed;
    }

    public Row getRowKey() {
        return this.insUp.getRowKey();
    }

    public ObTableFilter getFilter() {
        return this.filter;
    }

    public InsertOrUpdate getInsUp() {
        return this.insUp;
    }

    public boolean isCheckExists() {
        return this.checkExists;
    }

    public boolean isRollbackWhenCheckFailed() {
        return this.rollbackWhenCheckFailed;
    }

    public MutationResult execute() throws Exception {
        if (null == this.tableName || this.tableName.isEmpty()) {
            throw new ObTableException("table name is null");
        }
        if (null == this.client) {
            throw new ObTableException("client is null");
        }
        if (!(this.client instanceof ObTableClient)) {
            throw new ObTableException("the client must be table clinet");
        }
        TableQuery query = this.client.query(this.tableName);
        query.setFilter(this.filter);
        Row rowKey = this.getRowKey();
        ArrayList<ObNewRange> ranges = new ArrayList<ObNewRange>();
        ObNewRange range = new ObNewRange();
        range.setStartKey(ObRowKey.getInstance(this.insUp.getRowKey().getValues()));
        range.setEndKey(ObRowKey.getInstance(this.insUp.getRowKey().getValues()));
        ranges.add(range);
        query.getObTableQuery().setKeyRanges(ranges);
        ObTableOperation operation = ObTableOperation.getInstance(ObTableOperationType.INSERT_OR_UPDATE, this.insUp.getRowKey().getValues(), this.insUp.getColumns(), this.insUp.getValues());
        return new MutationResult(((ObTableClient)this.client).mutationWithFilter(query, rowKey, ranges, operation, false, true, this.checkExists, this.rollbackWhenCheckFailed));
    }
}

