/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadIllegalArgumentException;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import java.util.ArrayList;
import java.util.List;

public class ObDirectLoadBucket {
    private static final ObDirectLoadLogger logger = ObDirectLoadLogger.getLogger();
    private static final int integerReservedSize = 5;
    private static final int reservedSize = 10;
    private static final int defaultBufferSize = 0x100000;
    private final int bufferSize;
    private ArrayList<ObByteBuf> payloadBufferList = new ArrayList(64);
    private int totalRowCount = 0;
    private ObByteBuf buffer = null;
    private int currentRowCount = 0;
    private Row row = new Row();

    public ObDirectLoadBucket() {
        this.bufferSize = 0x100000;
    }

    public ObDirectLoadBucket(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isEmpty() {
        return this.getRowNum() == 0;
    }

    public int getRowNum() {
        return this.totalRowCount + this.currentRowCount;
    }

    public String toString() {
        return String.format("{rowNum:%d}", this.getRowNum());
    }

    public void addRow(ObObj[] cells) throws ObDirectLoadException {
        if (cells == null || cells.length == 0) {
            logger.warn("cells cannot be null or empty, cells:" + cells);
            throw new ObDirectLoadIllegalArgumentException("cells cannot be null or empty, cells:" + cells);
        }
        this.row.setCells(cells);
        this.appendRow(this.row);
    }

    public void addRow(List<ObObj> cells) throws ObDirectLoadException {
        if (cells == null || cells.isEmpty()) {
            logger.warn("cells cannot be null or empty, cells:" + cells);
            throw new ObDirectLoadIllegalArgumentException("cells cannot be null or empty, cells:" + cells);
        }
        this.row.setCells(cells);
        this.appendRow(this.row);
    }

    private void appendRow(Row row) {
        int rowEncodedSize = row.getEncodedSize();
        while (true) {
            if (this.buffer == null) {
                this.allocBuffer(rowEncodedSize);
                continue;
            }
            if (this.buffer.writableBytes() >= rowEncodedSize) break;
            this.sealBuffer();
        }
        row.encode(this.buffer);
        ++this.currentRowCount;
    }

    private void allocBuffer(int encodedSize) {
        int needSize = encodedSize + 10;
        int allocBufferSize = (needSize + this.bufferSize - 1) / this.bufferSize * this.bufferSize;
        this.buffer = new ObByteBuf(allocBufferSize);
        this.buffer.reserve(10);
    }

    private void sealBuffer() {
        this.encodeVi32(this.buffer.bytes, 5, this.currentRowCount);
        this.encodeVi32(this.buffer.bytes, 0, this.buffer.readableBytes() - 5);
        this.payloadBufferList.add(this.buffer);
        this.totalRowCount += this.currentRowCount;
        this.currentRowCount = 0;
        this.buffer = null;
    }

    private void encodeVi32(byte[] buf, int pos, int value) {
        int i = 0;
        while (i < 4) {
            buf[pos] = (byte)(value | 0x80);
            value >>>= 7;
            ++i;
            ++pos;
        }
        buf[pos] = (byte)(value & 0x7F);
    }

    public List<ObByteBuf> getPayloadBufferList() {
        if (this.buffer != null) {
            this.sealBuffer();
        }
        return this.payloadBufferList;
    }

    private static class Row {
        private final long SeqNo = 0L;
        private ObObj[] cells = null;

        public void setCells(ObObj[] cells) {
            this.cells = cells;
        }

        public void setCells(List<ObObj> cells) {
            this.cells = cells.toArray(new ObObj[0]);
        }

        public void encode(ObByteBuf buf) {
            Serialization.encodeVi64(buf, 0L);
            Serialization.encodeVi32(buf, this.cells.length);
            for (int i = 0; i < this.cells.length; ++i) {
                this.cells[i].encode(buf);
            }
        }

        public int getEncodedSize() {
            int size = 0;
            size += Serialization.getNeedBytes(0L);
            size += Serialization.getNeedBytes(this.cells.length);
            for (int i = 0; i < this.cells.length; ++i) {
                size += this.cells[i].getEncodedSize();
            }
            return size;
        }
    }
}

