/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadConnection;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;

public class ObDirectLoadConnectionFactory {
    private static final ObDirectLoadLogger logger = ObDirectLoadLogger.getLogger();

    public ObDirectLoadConnection createConnection() throws ObDirectLoadException {
        ObDirectLoadConnection connection = new ObDirectLoadConnection(this);
        logger.debug("create connection, id:" + connection.getTraceId());
        return connection;
    }

    public void closeConnection(ObDirectLoadConnection connection) {
        if (connection == null) {
            return;
        }
        logger.debug("close connection, id:" + connection.getTraceId());
    }

    public ObDirectLoadConnection buildConnection(ObDirectLoadConnection.Builder builder) throws ObDirectLoadException {
        ObDirectLoadConnection connection = null;
        try {
            connection = this.createConnection();
            connection.init(builder);
        }
        catch (Exception e) {
            logger.warn("build connection failed, args:" + builder, e);
            throw e;
        }
        return connection;
    }
}

