/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicLong;

public class ObDirectLoadTraceId {
    private final long uniqueId;
    private final long sequence;
    public static final ObDirectLoadTraceId DEFAULT_TRACE_ID = new ObDirectLoadTraceId(0L, 0L);
    public static TraceIdGenerator traceIdGenerator = new TraceIdGenerator();

    public ObDirectLoadTraceId(long uniqueId, long sequence) {
        this.uniqueId = uniqueId;
        this.sequence = sequence;
    }

    public String toString() {
        return String.format("Y%X-%016X", this.uniqueId, this.sequence);
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public long getSequence() {
        return this.sequence;
    }

    public static ObDirectLoadTraceId generateTraceId() {
        return traceIdGenerator.generate();
    }

    public static class TraceIdGenerator {
        private final ObDirectLoadLogger logger = ObDirectLoadLogger.getLogger();
        private final long uniqueId;
        private AtomicLong sequence;

        public TraceIdGenerator() {
            long ip = 0L;
            try {
                ip = TraceIdGenerator.ipToLong(InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception e) {
                this.logger.warn("get local host address failed", e);
            }
            long port = (long)(Math.random() % 65536.0) << 32;
            long isUserRequest = 0x1000000000000L;
            long reserved = 0L;
            this.uniqueId = ip | port | isUserRequest | reserved;
            this.sequence = new AtomicLong(0L);
        }

        private static long ipToLong(String strIp) {
            String[] ip = strIp.split("\\.");
            return (Long.parseLong(ip[0]) << 24) + (Long.parseLong(ip[1]) << 16) + (Long.parseLong(ip[2]) << 8) + Long.parseLong(ip[3]);
        }

        public ObDirectLoadTraceId generate() {
            long newSequence = System.currentTimeMillis() * 1000L + this.sequence.incrementAndGet() % 1000L;
            return new ObDirectLoadTraceId(this.uniqueId, newSequence);
        }
    }
}

