/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.future;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadStatement;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadExceptionUtil;
import com.alipay.oceanbase.rpc.direct_load.future.ObDirectLoadStatementPromiseTask;
import com.alipay.oceanbase.rpc.util.NamedThreadFactory;
import com.alipay.remoting.util.NettyEventLoopUtil;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class ObDirectLoadStatementAsyncPromiseTask
extends ObDirectLoadStatementPromiseTask {
    private static final int backgroundThreadCount = 2;
    private static final EventLoopGroup eventLoopGroup = NettyEventLoopUtil.newEventLoopGroup((int)2, (ThreadFactory)new NamedThreadFactory("direct-load", true));

    public ObDirectLoadStatementAsyncPromiseTask(ObDirectLoadStatement statement) {
        super(statement);
    }

    public void submit() throws ObDirectLoadException {
        try {
            eventLoopGroup.submit((Runnable)this);
        }
        catch (Exception e) {
            ObDirectLoadException cause = ObDirectLoadExceptionUtil.convertException(e);
            this.setFailure(cause);
            throw cause;
        }
    }

    protected void schedule(long delay, TimeUnit unit) throws ObDirectLoadException {
        try {
            eventLoopGroup.schedule((Runnable)this, delay, unit);
        }
        catch (Exception e) {
            ObDirectLoadException cause = ObDirectLoadExceptionUtil.convertException(e);
            throw cause;
        }
    }

    protected void schedule(long delayMillis) throws ObDirectLoadException {
        this.schedule(delayMillis, TimeUnit.MILLISECONDS);
    }
}

