/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.direct_load.protocol;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadLogger;
import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadTraceId;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadNotSupportedException;
import com.alipay.oceanbase.rpc.direct_load.protocol.ObDirectLoadProtocol;
import com.alipay.oceanbase.rpc.direct_load.protocol.v0.ObDirectLoadProtocolV0;

public class ObDirectLoadProtocolFactory {
    private static final ObDirectLoadLogger logger = ObDirectLoadLogger.getLogger();
    public static final long OB_VERSION_4_2_1_0 = ObGlobal.calcVersion(4, (short)2, (byte)1, (byte)0);
    public static final long OB_VERSION_4_2_2_0 = ObGlobal.calcVersion(4, (short)2, (byte)2, (byte)0);
    public static final long OB_VERSION_4_3_0_0 = ObGlobal.calcVersion(4, (short)3, (byte)0, (byte)0);
    public static final long OB_VERSION_4_2_1_7 = ObGlobal.calcVersion(4, (short)2, (byte)1, (byte)7);
    public static final long OB_VERSION_4_2_4_0 = ObGlobal.calcVersion(4, (short)2, (byte)4, (byte)0);
    public static final long OB_VERSION_4_3_0_1 = ObGlobal.calcVersion(4, (short)3, (byte)0, (byte)1);

    public static long getSupportedMinimumObVersion(long obVersion) {
        long minimumObVersion = 0L;
        minimumObVersion = obVersion < OB_VERSION_4_2_1_0 ? OB_VERSION_4_2_1_7 : (obVersion < OB_VERSION_4_2_2_0 ? OB_VERSION_4_2_1_7 : (obVersion < OB_VERSION_4_3_0_0 ? OB_VERSION_4_2_4_0 : OB_VERSION_4_3_0_1));
        return minimumObVersion;
    }

    public static boolean checkIsSupported(long obVersion) {
        long minimumObVersion = ObDirectLoadProtocolFactory.getSupportedMinimumObVersion(obVersion);
        return obVersion >= minimumObVersion;
    }

    public static ObDirectLoadProtocol getProtocol(ObDirectLoadTraceId traceId, long obVersion) throws ObDirectLoadException {
        long minimumObVersion = ObDirectLoadProtocolFactory.getSupportedMinimumObVersion(obVersion);
        if (obVersion < minimumObVersion) {
            logger.warn("direct load in ob version " + ObGlobal.getObVsnString(obVersion) + "is not supported, minimum version required is " + ObGlobal.getObVsnString(minimumObVersion));
            throw new ObDirectLoadNotSupportedException("direct load in ob version " + ObGlobal.getObVsnString(obVersion) + " is not supported, minimum version required is " + ObGlobal.getObVsnString(minimumObVersion));
        }
        return new ObDirectLoadProtocolV0(traceId, obVersion);
    }
}

