/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.filter;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.filter.ObCompareOp;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.filter.ObTableFilterFactory;
import com.alipay.oceanbase.rpc.filter.ObTableFilterList;
import java.util.List;

public class ObTableInFilter
extends ObTableFilter {
    private String columnName;
    private Object[] values;

    public ObTableInFilter(String columnName, Object ... values) {
        if (null == columnName || columnName.isEmpty()) {
            throw new ObTableException("column name is null");
        }
        if (null == values || values.length == 0) {
            throw new ObTableException("in filter values should not be empty");
        }
        this.columnName = columnName;
        this.values = values;
    }

    public ObTableInFilter(String columnName, List<Object> values) {
        if (null == columnName || columnName.isEmpty()) {
            throw new ObTableException("column name is null");
        }
        if (null == values || values.isEmpty()) {
            throw new ObTableException("in filter values should not be empty");
        }
        this.columnName = columnName;
        this.values = values.toArray();
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String toString() {
        ObTableFilterList filterList = ObTableFilterFactory.orList(new ObTableFilter[0]);
        for (Object value : this.values) {
            filterList.addFilter(ObTableFilterFactory.compareVal(ObCompareOp.EQ, this.columnName, value));
        }
        return filterList.toString();
    }
}

